/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.utils.vt100;

import org.eclipse.ptp.cell.utils.debug.Debug;
import org.eclipse.ptp.cell.utils.vt100.CSIParameter;
import org.eclipse.ptp.cell.utils.vt100.VT100Listener;

public class VT100Decoder {
    private static final int PARSER_STATE_TEXT = 1;
    private static final int PARSER_STATE_ESCAPE = 2;
    private static final int PARSER_STATE_CSI = 3;
    private static final int PARSER_STATE_OSC = 4;
    private int currentMode = 1;
    private static final byte ESC_CHAR = 27;
    private static final byte BELL_CHAR = 7;
    private StringBuffer escapeSequence = null;
    CSIParameter csiParameter = null;
    private VT100Listener listener;
    private int BUFFER_SIZE = 1000;
    private byte[] buffer = new byte[this.BUFFER_SIZE];

    public VT100Decoder(VT100Listener listener) {
        Debug.read();
        this.listener = listener;
    }

    public void receive(byte[] bytes, int length) {
        if (Debug.DEBUG_VT100) {
            Debug.POLICY.trace("Received {0} bytes", length);
        }
        int start = 0;
        block12: while (start < length) {
            block1 : switch (this.currentMode) {
                case 1: {
                    if (Debug.DEBUG_VT100) {
                        Debug.POLICY.trace("In text mode");
                    }
                    int end = start;
                    int max_end = start + this.BUFFER_SIZE;
                    if (max_end > length) {
                        max_end = length;
                    }
                    while (end < max_end) {
                        if (bytes[end] == 27) {
                            this.currentMode = 2;
                            break;
                        }
                        ++end;
                    }
                    int text_length = end - start;
                    if (text_length > 0) {
                        System.arraycopy(bytes, start, this.buffer, 0, text_length);
                        if (Debug.DEBUG_VT100) {
                            Debug.POLICY.trace("Parsed {0} bytes of text.", length);
                            if (Debug.DEBUG_VT100_MORE) {
                                Debug.POLICY.trace(new String(this.buffer, 0, length));
                            }
                        }
                        try {
                            this.listener.textSequence(this.buffer, text_length);
                        }
                        catch (Exception e) {
                            Debug.POLICY.error(Debug.DEBUG_VT100, e);
                        }
                    }
                    start = end;
                    if (this.currentMode != 2) continue block12;
                    this.escapeSequence = new StringBuffer();
                    this.escapeSequence.append(27);
                    ++start;
                    break;
                }
                case 2: {
                    byte b = bytes[start];
                    ++start;
                    this.escapeSequence.append((char)b);
                    switch (b) {
                        case 91: {
                            this.currentMode = 3;
                            this.csiParameter = new CSIParameter();
                            break block1;
                        }
                        case 93: {
                            this.currentMode = 4;
                            break block1;
                        }
                    }
                    this.currentMode = 1;
                    break;
                }
                case 3: {
                    byte b = bytes[start];
                    ++start;
                    this.escapeSequence.append((char)b);
                    this.csiParameter.receive(b);
                    if (!this.csiParameter.isValid()) {
                        String s = this.escapeSequence.toString();
                        byte[] sbytes = s.getBytes();
                        if (Debug.DEBUG_VT100) {
                            Debug.POLICY.trace("Parsed {0} bytes of text (initially considered as CSI sequence).", length);
                            if (Debug.DEBUG_VT100_MORE) {
                                Debug.POLICY.trace(new String(this.buffer, 0, length));
                            }
                        }
                        this.listener.textSequence(sbytes, sbytes.length);
                        this.currentMode = 1;
                        break;
                    }
                    if (!this.csiParameter.isComplete()) continue block12;
                    if (Debug.DEBUG_VT100) {
                        Debug.POLICY.trace("Ignored CSI sequence {0}.", this.csiParameter.toString());
                    }
                    this.currentMode = 1;
                    break;
                }
                case 4: {
                    byte b = bytes[start];
                    ++start;
                    this.escapeSequence.append((char)b);
                    if (b != 7) continue block12;
                    if (Debug.DEBUG_VT100) {
                        Debug.POLICY.trace("Ignored OSC sequence {0}.");
                    }
                    this.currentMode = 1;
                    break;
                }
                default: {
                    this.currentMode = 1;
                }
            }
        }
    }
}

