/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.launcher.cellbe.ui;

import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.ptp.cell.environment.launcher.cellbe.debug.Debug;
import org.eclipse.ptp.cell.environment.launcher.cellbe.internal.TargetLaunchDelegate;
import org.eclipse.ptp.cell.environment.launcher.cellbe.ui.Messages;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.launcher.core.LinuxPath;
import org.eclipse.ptp.remotetools.environment.launcher.preferences.LaunchPreferences;
import org.eclipse.ptp.utils.ui.swt.ControlsRelationshipHandler;
import org.eclipse.ptp.utils.ui.swt.Frame;
import org.eclipse.ptp.utils.ui.swt.TextGroup;
import org.eclipse.ptp.utils.ui.swt.TextMold;
import org.eclipse.ptp.utils.ui.swt.ToolKit;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TargetTab
extends AbstractLaunchConfigurationTab {
    protected Combo targetList;
    protected TextGroup remoteDirectoryGroup;
    protected Button doExportX11;
    protected Button doCleanup;
    protected Button doAutomaticWorkingDir;
    private TabModifyListener modifyListener;
    private ControlsRelationshipHandler remoteDirectoryEnabler;

    public void createControl(Composite parent) {
        this.setErrorMessage(null);
        this.setMessage(Messages.TargetTab_Tab_Message);
        Composite topControl = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topControl.setLayout((Layout)topLayout);
        this.setControl((Control)topControl);
        this.modifyListener = new TabModifyListener();
        this.createTargetGroup(topControl);
        this.createWorkingDirectoryComponent(topControl);
        this.createOptionsGroup(topControl);
    }

    protected void createTargetGroup(Composite comp) {
        Group group = ToolKit.createGroup((Composite)comp, (String)Messages.TargetTab_TargetFrame_Title);
        this.targetList = ToolKit.createShortDropDownRow((Composite)group, (String)Messages.TargetTab_TargetFrame_TargetListLabel);
        String[] targets = EnvironmentPlugin.getDefault().getTargetsManager().getAllConfigNames();
        int i = 0;
        while (i < targets.length) {
            this.targetList.add(targets[i]);
            ++i;
        }
        this.targetList.addSelectionListener((SelectionListener)this.modifyListener);
    }

    protected void createOptionsGroup(Composite comp) {
        Frame frame = new Frame(comp, Messages.TargetTab_OptionsFrame_Title);
        Composite group = frame.getTopUserReservedComposite();
        this.doExportX11 = this.createCheckButton(group, Messages.TargetTab_OptionsFrame_ExportX11ButtonLabel);
        this.doExportX11.addSelectionListener((SelectionListener)this.modifyListener);
        Label label = new Label(group, 64);
        label.setText(Messages.TargetTab_OptionsFrame_ExportX11Note);
    }

    protected void createWorkingDirectoryComponent(Composite comp) {
        Frame frame = new Frame(comp, Messages.TargetTab_WorkingDirectoryFrame_Title);
        Composite group = frame.getTopUserReservedComposite();
        this.doAutomaticWorkingDir = this.createCheckButton(group, Messages.TargetTab_WorkingDirectoryFrame_UseDefaultButtonLabel);
        this.doAutomaticWorkingDir.addSelectionListener((SelectionListener)this.modifyListener);
        TextMold remoteDirectoryMold = new TextMold(TextMold.LABELABOVE | TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_GRAB_EXCESS_SPACE, Messages.TargetTab_WorkingDirectoryFrame_DirectoryFieldLabel);
        this.remoteDirectoryGroup = new TextGroup(group, remoteDirectoryMold);
        this.remoteDirectoryGroup.addModifyListener((ModifyListener)this.modifyListener);
        this.doCleanup = this.createCheckButton(group, Messages.TargetTab_WorkingDirectoryFrame_CleanUpButtonLabel);
        this.doCleanup.addSelectionListener((SelectionListener)this.modifyListener);
        this.remoteDirectoryEnabler = new ControlsRelationshipHandler(this.doAutomaticWorkingDir, (Control)this.remoteDirectoryGroup, false);
    }

    public boolean isValid(ILaunchConfiguration config) {
        if (!super.isValid(config)) {
            return false;
        }
        TargetLaunchDelegate delegate = new TargetLaunchDelegate();
        try {
            LinuxPath.toString((IPath)delegate.getValidatedRemoteDirectory(config));
            delegate.getValidatedTargetControl(config);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean canSave() {
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        String[] targets = EnvironmentPlugin.getDefault().getTargetsManager().getAllConfigNames();
        if (targets.length > 0) {
            configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.cellbe.CELL_TARGET", targets[0]);
        }
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.AUTO_REMOTE_DIRECTORY", true);
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_CLEANUP", true);
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.REMOTE_DIRECTORY", LaunchPreferences.getPreferenceStore().getString("org.eclipse.ptp.remotetools.environment.launcher.preferences-working-directory"));
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.FORWARD_X11", false);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            int selected = -1;
            String current = null;
            try {
                current = configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.cellbe.CELL_TARGET", "");
            }
            catch (CoreException coreException) {
                current = "";
            }
            int i = 0;
            while (i < this.targetList.getItemCount()) {
                if (current.equals(this.targetList.getItem(i))) {
                    selected = i;
                }
                ++i;
            }
            this.targetList.select(selected);
            this.doAutomaticWorkingDir.setSelection(configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.AUTO_REMOTE_DIRECTORY", true));
            this.remoteDirectoryEnabler.manageDependentControls(this.doAutomaticWorkingDir);
            this.doCleanup.setSelection(configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_CLEANUP", true));
            this.remoteDirectoryGroup.setString(configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.REMOTE_DIRECTORY", LaunchPreferences.getPreferenceStore().getString("org.eclipse.ptp.remotetools.environment.launcher.preferences-working-directory")));
            this.doExportX11.setSelection(configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.FORWARD_X11", false));
        }
        catch (CoreException e) {
            this.setErrorMessage(LaunchMessages.getFormattedString((String)"Launch.common.Exception_occurred_reading_configuration_EXCEPTION", (String)e.getStatus().getMessage()));
            LaunchUIPlugin.log((Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int selection = this.targetList.getSelectionIndex();
        if (selection > -1) {
            configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.cellbe.CELL_TARGET", this.targetList.getItem(selection));
        } else {
            configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.cellbe.CELL_TARGET", null);
        }
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.AUTO_REMOTE_DIRECTORY", this.doAutomaticWorkingDir.getSelection());
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.REMOTE_DIRECTORY", this.remoteDirectoryGroup.getString());
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.FORWARD_X11", this.doExportX11.getSelection());
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_CLEANUP", this.doCleanup.getSelection());
    }

    public String getName() {
        return Messages.TargetTab_Tab_Title;
    }

    public Image getImage() {
        return null;
    }

    private class TabModifyListener
    implements ModifyListener,
    SelectionListener {
        private TabModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            try {
                TargetTab.this.updateLaunchConfigurationDialog();
            }
            catch (Exception ee) {
                Debug.POLICY.logError((Throwable)ee);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            try {
                TargetTab.this.updateLaunchConfigurationDialog();
            }
            catch (Exception ee) {
                Debug.POLICY.logError((Throwable)ee);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                TargetTab.this.updateLaunchConfigurationDialog();
            }
            catch (Exception ee) {
                Debug.POLICY.logError((Throwable)ee);
            }
        }
    }
}

