/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.pdt.xml.core;

import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ptp.cell.pdt.xml.core.AbstractPdtXmlGenerator;
import org.eclipse.ptp.cell.pdt.xml.core.PdtXmlGenerationException;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.Event;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroup;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroupForest;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventSubgroup;
import org.eclipse.ptp.cell.pdt.xml.debug.Debug;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CellPdtXmlGenerator
extends AbstractPdtXmlGenerator {
    protected Boolean ppeProfiling;
    protected Boolean speProfiling;

    public CellPdtXmlGenerator(IPath xmlFilePath, EventGroupForest eventGroupForest, Boolean ppeProfiling, Boolean speProfiling) {
        super(xmlFilePath, eventGroupForest);
        this.ppeProfiling = ppeProfiling;
        this.speProfiling = speProfiling;
    }

    public Document generatePdtXmlDocument() {
        Debug.read();
        if (Debug.DEBUG_XML_GENERATOR) {
            Debug.POLICY.enter();
            Debug.POLICY.trace("EventGroupForest: {0}", (Object[])this.eventGroupForest.toStringVector());
            Debug.POLICY.trace("PPE profiling enable: {0}  SPE profiling enable: {1}", new Object[]{this.ppeProfiling, this.speProfiling});
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder xmlBuilder = factory.newDocumentBuilder();
            Document xml = xmlBuilder.newDocument();
            Element pdtConfigElement = this.createPdtConfigElement(xml);
            this.createGroupsElement(xml, pdtConfigElement);
            String confName = "CBE";
            Element parentGrpCtlElement = this.createConfigurationElement(xml, pdtConfigElement, confName, "none", this.ppeProfiling);
            Element childGrpCtlElement = null;
            childGrpCtlElement = this.createConfigurationElement(xml, pdtConfigElement, "SPE", confName, this.speProfiling);
            HashMap<EventGroup, Element> ppeGroupMap = new HashMap<EventGroup, Element>();
            HashMap speGroupMap = new HashMap();
            for (EventGroup group : this.eventGroupForest.getVisibleGroups()) {
                HashMap<EventSubgroup, Element> ppeSubgroupMap = new HashMap<EventSubgroup, Element>();
                HashMap speSubgroupMap = new HashMap();
                for (EventSubgroup subgroup : group.getSubgroups()) {
                    for (Event event : subgroup.getEvents()) {
                        Element eventElement = xml.createElement("event");
                        eventElement.setAttribute("name", event.getName());
                        eventElement.setAttribute("active", String.valueOf(event.getActive()));
                        String include = event.getInclude();
                        HashMap<EventGroup, Element> selGroupMap = null;
                        HashMap<EventSubgroup, Element> selSubgroupMap = null;
                        Element selGrpCtlElement = null;
                        if (include.matches(".*pdt_ppe_event_header\\.xml$")) {
                            selGroupMap = ppeGroupMap;
                            selSubgroupMap = ppeSubgroupMap;
                            selGrpCtlElement = parentGrpCtlElement;
                        } else if (include.matches(".*pdt_spe_event_header\\.xml$")) {
                            selGroupMap = speGroupMap;
                            selSubgroupMap = speSubgroupMap;
                            selGrpCtlElement = childGrpCtlElement;
                        }
                        Element selSubgroupElement = (Element)selSubgroupMap.get(subgroup);
                        if (selSubgroupElement == null) {
                            selSubgroupElement = this.createSubgroupElement(xml, subgroup);
                            selSubgroupMap.put(subgroup, selSubgroupElement);
                            Element selGroupElement = (Element)selGroupMap.get(group);
                            if (selGroupElement == null) {
                                selGroupElement = this.createGroupElement(xml, group);
                                selGroupMap.put(group, selGroupElement);
                                selGrpCtlElement.appendChild(selGroupElement);
                            }
                            selGroupElement.appendChild(selSubgroupElement);
                        }
                        selSubgroupElement.appendChild(eventElement);
                    }
                }
            }
            Debug.POLICY.exit(Debug.DEBUG_XML_GENERATOR);
            return xml;
        }
        catch (ParserConfigurationException e) {
            Debug.POLICY.error(Debug.DEBUG_XML_GENERATOR, (Throwable)e);
            throw new PdtXmlGenerationException(e);
        }
    }
}

