/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.internal;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.perf.IPerformanceLaunchConfigurationConstants;
import org.eclipse.ptp.perf.internal.PerfStep;
import org.eclipse.ptp.perf.toolopts.ExecTool;

public class PerfLauncher
extends PerfStep
implements IPerformanceLaunchConfigurationConstants {
    private static final boolean traceOn = false;
    private String progPath = null;
    private String application = null;
    private String saveApp = null;
    private String saveArgs = null;
    private String savePath = null;
    private boolean swappedArgs = false;
    private Map<String, String> saveEnv = null;
    private boolean swappedEnv = false;
    private String appnameattrib = null;
    private String apppathattrib = null;
    private String appargattrib = null;
    private ILaunch launch = null;
    private LaunchConfigurationDelegate paraDel = null;
    private ExecTool tool = null;

    public PerfLauncher(ILaunchConfiguration conf, ExecTool etool, String progPath, LaunchConfigurationDelegate pd, ILaunch launcher) throws CoreException {
        super(conf, "Running Application");
        this.launch = launcher;
        this.tool = etool;
        this.paraDel = pd;
        this.appnameattrib = conf.getAttribute("perf_executable_name_tag_for_name_value", null);
        this.apppathattrib = conf.getAttribute("perf_executable_path_tag_for_path_value", null);
        this.appargattrib = conf.getAttribute("perf_framework_attribute_for_arguments_value", null);
        this.progPath = progPath;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (!this.performLaunch(this.paraDel, this.launch, monitor)) {
                return new Status(2, "com.ibm.jdg2e.concurrency", 2, "Nothing to run", null);
            }
        }
        catch (Exception e) {
            try {
                this.cleanup();
            }
            catch (CoreException coreException) {}
            return new Status(4, "com.ibm.jdg2e.concurrency", 4, "Execution Error", (Throwable)e);
        }
        return new Status(0, "com.ibm.jdg2e.concurrency", 0, "Execution Complete", null);
    }

    public boolean performLaunch(LaunchConfigurationDelegate paraDel, ILaunch launch, IProgressMonitor monitor) throws Exception {
        try {
            ILaunchConfigurationWorkingCopy confWC = this.configuration.getWorkingCopy();
            this.application = confWC.getAttribute(this.appnameattrib, null);
            if (this.progPath != null) {
                confWC.setAttribute(this.appnameattrib, this.progPath);
                if (this.apppathattrib != null) {
                    IFile path = this.thisProject.getFile(this.progPath);
                    this.savePath = confWC.getAttribute(this.apppathattrib, null);
                    confWC.setAttribute(this.apppathattrib, path.getLocation().toString());
                }
            }
            if (this.tool != null) {
                String prog = confWC.getAttribute(this.appnameattrib, "");
                String arg = confWC.getAttribute(this.appargattrib, "");
                this.saveApp = prog;
                this.saveArgs = arg;
                LinkedHashMap envMap = new LinkedHashMap();
                if (this.tool.execUtils != null && this.tool.execUtils.length > 0) {
                    String firstExecUtil = PerfLauncher.getToolExecutable(this.tool.execUtils[0]);
                    File f = new File(firstExecUtil);
                    if (firstExecUtil == null || !f.exists()) {
                        throw new Exception("Tool " + firstExecUtil + " not found");
                    }
                    confWC.setAttribute(this.appnameattrib, firstExecUtil);
                    String otherUtils = this.getToolArguments(this.tool.execUtils[0], this.configuration, this.projectLocation, this.projectLocation);
                    int i = 1;
                    while (i < this.tool.execUtils.length) {
                        otherUtils = String.valueOf(otherUtils) + " " + this.getToolCommand(this.tool.execUtils[i], this.configuration, this.projectLocation, this.projectLocation);
                        ++i;
                    }
                    this.swappedArgs = true;
                    String toArgs = String.valueOf(otherUtils) + " " + prog + " " + arg;
                    System.out.println("PerfLaunchSteps.performLaunch() on: " + firstExecUtil + "|" + toArgs);
                    confWC.setAttribute(this.appargattrib, toArgs);
                    int i2 = 0;
                    while (i2 < this.tool.execUtils.length) {
                        envMap.putAll(this.tool.execUtils[i2].getEnvVars(this.configuration));
                        ++i2;
                    }
                }
                if (this.tool.global != null) {
                    envMap.putAll(this.tool.global.getEnvVars(this.configuration));
                }
                if (envMap.size() > 0) {
                    this.saveEnv = confWC.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
                    LinkedHashMap<Object, Object> newvars = null;
                    newvars = this.saveEnv != null ? new LinkedHashMap<String, String>(this.saveEnv) : new LinkedHashMap();
                    newvars.putAll(envMap);
                    this.swappedEnv = true;
                    confWC.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, newvars);
                }
            }
            this.configuration = confWC.doSave();
            boolean reRun = launch.isTerminated();
            if (reRun) {
                IProcess[] ip;
                IProcess[] iProcessArray = ip = launch.getProcesses();
                int n = ip.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess p = iProcessArray[n2];
                    launch.removeProcess(p);
                    ++n2;
                }
            }
            paraDel.launch(this.configuration, "run", launch, monitor);
            while (!launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    launch.terminate();
                    this.cleanup();
                    throw new OperationCanceledException();
                }
                Thread.sleep(1000L);
            }
            return true;
        }
        finally {
            this.cleanup();
        }
    }

    public void cleanup() throws CoreException {
        ILaunchConfigurationWorkingCopy confWC = this.configuration.getWorkingCopy();
        if (this.apppathattrib != null && this.savePath != null) {
            confWC.setAttribute(this.apppathattrib, this.savePath);
        }
        if (this.tool != null && this.swappedArgs) {
            confWC.setAttribute(this.appnameattrib, this.saveApp);
            confWC.setAttribute(this.appargattrib, this.saveArgs);
        }
        if (this.tool != null && this.swappedEnv) {
            confWC.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, this.saveEnv);
        }
        confWC.setAttribute(this.appnameattrib, this.application);
        this.configuration = confWC.doSave();
    }
}

