/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.ui;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ptp.perf.Activator;
import org.eclipse.ptp.perf.IPerformanceLaunchConfigurationConstants;
import org.eclipse.ptp.perf.internal.BuildLaunchUtils;
import org.eclipse.ptp.perf.toolopts.PerformanceProcess;
import org.eclipse.ptp.perf.toolopts.ToolPane;
import org.eclipse.ptp.perf.toolopts.ToolPaneListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class PerformanceAnalysisTab
extends AbstractLaunchConfigurationTab
implements IPerformanceLaunchConfigurationConstants {
    protected boolean noPTP = false;
    protected final PerformanceProcess[] tools = Activator.getTools();
    protected Combo toolTypes;
    protected Button buildonlyCheck;
    protected Button analyzeonlyCheck;
    protected Button noParallelRun;
    protected Button addWorkflowB;
    protected Button removeWorkflowB;
    protected Button keepprofsCheck;
    protected final ToolPane[] panes = Activator.getToolPanes();
    protected WidgetListener listener = new WidgetListener();

    public PerformanceAnalysisTab(boolean noPar) {
        this.noPTP = noPar;
    }

    private void warnXMLChange() {
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"TAU Warning", (String)"Your changes will not take full effect until you open and close this window.");
    }

    private void addWorkflow() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText("Select tool definition xml file");
        String out = this.getFieldContent(dialog.open());
        if (out == null) {
            return;
        }
        File test = new File(out);
        if (!test.canRead() || !test.isFile()) {
            return;
        }
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        String fiList = preferences.getString("tool_def_xml_location");
        String[] x = fiList.split(",,,");
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        int i = 0;
        while (i < x.length) {
            files.add(x[i]);
            ++i;
        }
        files.add(out);
        fiList = "";
        Iterator fit = files.iterator();
        while (fit.hasNext()) {
            fiList = String.valueOf(fiList) + (String)fit.next();
            if (!fit.hasNext()) continue;
            fiList = String.valueOf(fiList) + ",,,";
        }
        preferences.setValue("tool_def_xml_location", fiList);
        Activator.getDefault().refreshTools();
        this.warnXMLChange();
    }

    private void removeWorkflow() {
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        String fiList = preferences.getString("tool_def_xml_location");
        String[] x = fiList.split(",,,");
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        int i = 0;
        while (i < x.length) {
            files.add(x[i]);
            ++i;
        }
        ArrayContentProvider acp = new ArrayContentProvider();
        ListDialog ld = new ListDialog(this.getShell());
        ld.setContentProvider((IStructuredContentProvider)acp);
        ld.setBlockOnOpen(true);
        ld.setLabelProvider((ILabelProvider)new LabelProvider());
        ld.setInput((Object)x);
        ld.setHelpAvailable(false);
        ld.setTitle("Remove Workflow Files");
        ld.open();
        if (ld.getReturnCode() == 1) {
            return;
        }
        Object[] y = ld.getResult();
        int i2 = 0;
        while (i2 < y.length) {
            files.remove((String)y[i2]);
            ++i2;
        }
        fiList = "";
        Iterator fit = files.iterator();
        while (fit.hasNext()) {
            fiList = String.valueOf(fiList) + (String)fit.next();
            if (!fit.hasNext()) continue;
            fiList = String.valueOf(fiList) + ",,,";
        }
        preferences.setValue("tool_def_xml_location", fiList);
        Activator.getDefault().refreshTools();
        this.warnXMLChange();
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        FillLayout topLayout = new FillLayout();
        comp.setLayout((Layout)topLayout);
        TabFolder tabParent = new TabFolder(comp, 2048);
        TabItem toolTab = new TabItem(tabParent, 0);
        toolTab.setText("Tool Selection");
        ScrolledComposite scrollTool = new ScrolledComposite((Composite)tabParent, 512);
        Composite toolComp = new Composite((Composite)scrollTool, 0);
        toolTab.setControl((Control)scrollTool);
        toolComp.setLayout((Layout)PerformanceAnalysisTab.createGridLayout(1, false, 0, 0));
        toolComp.setLayoutData((Object)PerformanceAnalysisTab.spanGridData(768, 5));
        this.createVerticalSpacer(toolComp, 1);
        Composite toolComboComp = new Composite(toolComp, 0);
        toolComboComp.setLayout((Layout)PerformanceAnalysisTab.createGridLayout(2, false, 0, 0));
        toolComboComp.setLayoutData((Object)new GridData(768));
        Label makeLab = new Label(toolComboComp, 0);
        makeLab.setText("Select Tool:");
        this.toolTypes = new Combo(toolComboComp, 2060);
        this.toolTypes.addSelectionListener((SelectionListener)this.listener);
        this.addWorkflowB = new Button(toolComboComp, 0);
        this.addWorkflowB.setText("Add Workflow XML File");
        this.addWorkflowB.addSelectionListener((SelectionListener)this.listener);
        this.removeWorkflowB = new Button(toolComboComp, 0);
        this.removeWorkflowB.setText("Remove Workflow XML File");
        this.removeWorkflowB.addSelectionListener((SelectionListener)this.listener);
        this.createVerticalSpacer(toolComp, 1);
        this.buildonlyCheck = this.createCheckButton(toolComp, "Build the instrumented executable but do not launch it");
        this.buildonlyCheck.addSelectionListener((SelectionListener)this.listener);
        this.analyzeonlyCheck = this.createCheckButton(toolComp, "Select existing performance data to analyze with the selected tool");
        this.analyzeonlyCheck.addSelectionListener((SelectionListener)this.listener);
        toolComp.pack();
        int toolCompHeight = toolComp.computeSize((int)-1, (int)-1).y;
        scrollTool.setContent((Control)toolComp);
        scrollTool.setMinSize(400, toolCompHeight);
        scrollTool.setExpandHorizontal(true);
        scrollTool.setExpandVertical(true);
        TabItem optionTab = null;
        ScrolledComposite scrollOption = null;
        Composite optionComp = null;
        int optionCompHeight = 400;
        if (this.panes != null) {
            int i = 0;
            while (i < this.panes.length) {
                if (!this.panes[i].virtual) {
                    optionTab = new TabItem(tabParent, 0);
                    optionTab.setText(this.panes[i].toolName);
                    scrollOption = new ScrolledComposite((Composite)tabParent, 512);
                    optionComp = new Composite((Composite)scrollOption, 0);
                    optionTab.setControl((Control)scrollOption);
                    optionComp.setLayout((Layout)PerformanceAnalysisTab.createGridLayout(1, false, 0, 0));
                    optionComp.setLayoutData((Object)PerformanceAnalysisTab.spanGridData(768, 5));
                    this.panes[i].makeToolPane(optionComp, (ToolPaneListener)new OptionsPaneListener(this.panes[i]));
                    optionComp.pack();
                    optionCompHeight = optionComp.computeSize((int)-1, (int)-1).y;
                    scrollOption.setContent((Control)optionComp);
                    scrollOption.setMinSize(400, optionCompHeight);
                    scrollOption.setExpandHorizontal(true);
                    scrollOption.setExpandVertical(true);
                }
                ++i;
            }
        }
    }

    public void updateComboFromSelection() {
        System.out.println("change startup");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.panes != null) {
            int i = 0;
            while (i < this.panes.length) {
                this.panes[i].setDefaults(configuration);
                ++i;
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.toolTypes.removeAll();
        if (this.tools == null || this.tools.length == 0) {
            this.toolTypes.add("Specify a valid tool configuration file in Performance Tool preferences");
            if (this.tools == null) {
                this.toolTypes.select(0);
                return;
            }
        }
        int i = 0;
        while (i < this.tools.length) {
            this.toolTypes.add(this.tools[i].toolName);
            ++i;
        }
        this.toolTypes.select(0);
        try {
            int toolDex = this.toolTypes.indexOf(configuration.getAttribute("selected_performance_tool", ""));
            if (toolDex >= 0) {
                this.toolTypes.select(toolDex);
            } else {
                this.toolTypes.select(0);
                if (configuration.getAttribute("selected_performance_tool", "").equals("")) {
                    this.updateLaunchConfigurationDialog();
                }
            }
            this.buildonlyCheck.setSelection(configuration.getAttribute("build_but_do_not_run_instrumented_executable", false));
            this.analyzeonlyCheck.setSelection(configuration.getAttribute("analyze_existing_perf_data_in_specified_location_build/run_nothing", false));
            if (this.panes != null) {
                int i2 = 0;
                while (i2 < this.panes.length) {
                    this.panes[i2].OptUpdate();
                    this.panes[i2].initializePane(configuration);
                    ++i2;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String selectedtool = this.toolTypes.getItem(this.toolTypes.getSelectionIndex());
        configuration.setAttribute("selected_performance_tool", selectedtool);
        if (this.tools != null && this.tools.length >= 1) {
            BuildLaunchUtils.verifyRequestToolPath(this.tools[this.toolTypes.getSelectionIndex()], false);
            configuration.setAttribute("true_if_using_performance_analysis_execution_utility", this.tools[this.toolTypes.getSelectionIndex()].prependExecution);
            configuration.setAttribute("true_if_recompiling_for_analysis", this.tools[this.toolTypes.getSelectionIndex()].recompile);
        }
        configuration.setAttribute("build_but_do_not_run_instrumented_executable", this.buildonlyCheck.getSelection());
        configuration.setAttribute("analyze_existing_perf_data_in_specified_location_build/run_nothing", this.analyzeonlyCheck.getSelection());
        if (this.panes != null) {
            int i = 0;
            while (i < this.panes.length) {
                this.panes[i].performApply(configuration);
                configuration.setAttribute(this.panes[i].configID, this.panes[i].getOptionString());
                configuration.setAttribute(this.panes[i].configVarID, this.panes[i].getVarMap());
                ++i;
            }
        }
    }

    protected String getFieldContent(IntegerFieldEditor editorField) {
        return this.getFieldContent(editorField.getStringValue());
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public String getName() {
        return "Performance Analysis";
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    protected static GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected static GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals("")) {
            return null;
        }
        return text;
    }

    protected class OptionsPaneListener
    extends ToolPaneListener {
        OptionsPaneListener(ToolPane tool) {
            super(tool);
        }

        protected void localAction() {
            PerformanceAnalysisTab.this.updateLaunchConfigurationDialog();
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source.equals(PerformanceAnalysisTab.this.addWorkflowB)) {
                PerformanceAnalysisTab.this.addWorkflow();
            }
            if (source.equals(PerformanceAnalysisTab.this.removeWorkflowB)) {
                PerformanceAnalysisTab.this.removeWorkflow();
            }
            PerformanceAnalysisTab.this.updateLaunchConfigurationDialog();
        }

        public void propertyChange(PropertyChangeEvent event) {
            PerformanceAnalysisTab.this.updateLaunchConfigurationDialog();
        }

        public void modifyText(ModifyEvent evt) {
            PerformanceAnalysisTab.this.updateLaunchConfigurationDialog();
        }
    }
}

