/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.alf.ui.wizard;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.cell.alf.ui.Messages;
import org.eclipse.ptp.cell.alf.ui.core.ALFConstants;
import org.eclipse.ptp.cell.alf.ui.debug.Debug;
import org.eclipse.ptp.cell.alf.ui.wizard.ALFWizard;
import org.eclipse.ptp.cell.alf.ui.wizard.ALFWizardPageB;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ALFWizardPageA
extends WizardPage {
    private static int MIN_STACK_SIZE = 10;
    private static int MAX_STACK_SIZE = 251904;
    private Text expectedStackSize;
    private Combo expectedNumAccelerators;
    private Combo partitionMethod;
    private Text partitionMethodHelpText;
    private Combo configuration;

    protected ALFWizardPageA(String pageName, String title, String description) {
        super(pageName);
        this.setTitle(title);
        this.setDescription(description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setFont(font);
        Composite stackSizeComposite = new Composite(composite, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        stackSizeComposite.setLayout((Layout)layout2);
        stackSizeComposite.setLayoutData((Object)new GridData(768));
        stackSizeComposite.setFont(font);
        Label stackSizeLabel = new Label(stackSizeComposite, 16448);
        stackSizeLabel.setText(Messages.ALFWizardPageA_stackSizeLabelMessage);
        stackSizeLabel.setLayoutData((Object)new GridData(36));
        stackSizeLabel.setFont(font);
        this.expectedStackSize = new Text(stackSizeComposite, 2052);
        this.expectedStackSize.setLayoutData((Object)new GridData(772));
        this.expectedStackSize.setText("10");
        this.expectedStackSize.setFont(font);
        this.expectedStackSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ALFWizardPageA.this.validateInput();
                    ALFWizardPageA.this.getWizard().getContainer().updateButtons();
                }
                catch (Exception ee) {
                    Debug.POLICY.logError((Throwable)ee);
                }
            }
        });
        Composite numAcceleratorsComposite = new Composite(composite, 0);
        numAcceleratorsComposite.setLayout((Layout)layout2);
        numAcceleratorsComposite.setLayoutData((Object)new GridData(768));
        numAcceleratorsComposite.setFont(font);
        Label numAcceleratorsLabel = new Label(numAcceleratorsComposite, 16448);
        numAcceleratorsLabel.setText(Messages.ALFWizardPageA_numAcceleratorsLabelMessage);
        numAcceleratorsLabel.setLayoutData((Object)new GridData(36));
        numAcceleratorsLabel.setFont(font);
        this.expectedNumAccelerators = new Combo(numAcceleratorsComposite, 12);
        this.expectedNumAccelerators.setLayoutData((Object)new GridData(644));
        this.expectedNumAccelerators.setFont(font);
        this.expectedNumAccelerators.add("0 " + Messages.ALFWizardPageA_allAvailableAccelerators, 0);
        int i = 1;
        while (i <= 16) {
            this.expectedNumAccelerators.add(String.valueOf(i), i);
            ++i;
        }
        this.expectedNumAccelerators.select(0);
        this.expectedNumAccelerators.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    ALFWizardPageB pageB = (ALFWizardPageB)ALFWizardPageA.this.getNextPage();
                    if (pageB != null) {
                        pageB.updateAndValidateBuffers();
                    }
                    ALFWizardPageA.this.getWizard().getContainer().updateButtons();
                }
                catch (Exception ee) {
                    Debug.POLICY.logError((Throwable)ee);
                }
            }
        });
        Composite partitionMethodLabelComposite = new Composite(composite, 0);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 3;
        partitionMethodLabelComposite.setLayout((Layout)layout3);
        partitionMethodLabelComposite.setLayoutData((Object)new GridData(768));
        partitionMethodLabelComposite.setFont(font);
        Label partitionMethodLabel = new Label(partitionMethodLabelComposite, 16448);
        partitionMethodLabel.setText(Messages.ALFWizardPageA_partitionMethodLabelMessage);
        partitionMethodLabel.setLayoutData((Object)new GridData(36));
        partitionMethodLabel.setFont(font);
        this.partitionMethodHelpText = ALFWizard.createWhatsThisHelpText(partitionMethodLabelComposite, this.getShell(), this.getWizard(), "data/partition_method_help.html", 325, 275);
        this.partitionMethodHelpText.getFont();
        this.partitionMethod = new Combo(partitionMethodLabelComposite, 12);
        this.partitionMethod.setLayoutData((Object)new GridData(644));
        this.partitionMethod.setFont(font);
        this.partitionMethod.add(Messages.ALFWizardPageA_partitionMethodHost, ALFConstants.ALF_PARTITION_HOST);
        this.partitionMethod.add(Messages.ALFWizardPageA_partitionMethodAccelerator, ALFConstants.ALF_PARTITION_ACCELERATOR);
        this.partitionMethod.select(ALFConstants.ALF_PARTITION_HOST);
        Composite configurationComposite = new Composite(composite, 0);
        configurationComposite.setLayout((Layout)layout2);
        configurationComposite.setLayoutData((Object)new GridData(768));
        configurationComposite.setFont(font);
        Label configurationLabel = new Label(configurationComposite, 16448);
        configurationLabel.setText(Messages.ALFWizardPageA_configurationLabelMessage);
        configurationLabel.setLayoutData((Object)new GridData(36));
        configurationLabel.setFont(font);
        this.configuration = new Combo(configurationComposite, 12);
        this.configuration.setLayoutData((Object)new GridData(644));
        this.configuration.setFont(font);
        this.configuration.add(Messages.ALFWizardPageA_configuration32bit, 0);
        this.configuration.add(Messages.ALFWizardPageA_configuration64bit, 1);
        this.configuration.select(0);
        this.setControl((Control)composite);
    }

    public int getExpAccelNum() {
        if (this.expectedNumAccelerators != null && !this.expectedNumAccelerators.isDisposed()) {
            return this.expectedNumAccelerators.getSelectionIndex();
        }
        return -1;
    }

    public int getExpStackSize() {
        if (this.expectedStackSize != null && !this.expectedStackSize.isDisposed()) {
            return Integer.parseInt(this.expectedStackSize.getText().trim());
        }
        return -1;
    }

    public int getPartitionMethod() {
        if (this.partitionMethod != null && !this.partitionMethod.isDisposed()) {
            return this.partitionMethod.getSelectionIndex();
        }
        return -1;
    }

    public boolean is64bit() {
        if (this.configuration == null) {
            return false;
        }
        return this.configuration.getSelectionIndex() == 1;
    }

    private void validateInput() {
        try {
            if (!(this.expectedStackSize == null || this.expectedStackSize.isDisposed() || Long.parseLong(this.expectedStackSize.getText()) >= (long)MIN_STACK_SIZE && Long.parseLong(this.expectedStackSize.getText()) <= (long)MAX_STACK_SIZE)) {
                this.setErrorMessage(Messages.ALFWizardPageA_errorMsgExpectedStackSize);
                this.setPageComplete(false);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.ALFWizardPageA_errorMsgExpectedStackSize);
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }
}

