/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.debug.sdm.core.utils.DebugUtil;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.rm.remote.core.AbstractRemoteResourceManagerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDMRunner
extends Job {
    private List<String> command;
    private String workDir;
    private SDMMasterState sdmState = SDMMasterState.STARTING;
    private IPJob ipJob = null;
    private IResourceManagerControl rmControl = null;
    private IRemoteProcess sdmProcess;

    public SDMRunner(IResourceManagerControl rmControl) {
        super("Master SDM control");
        this.setPriority(30);
        this.setSystem(true);
        this.setSystem(false);
        this.rmControl = rmControl;
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, "Created sdm master runner.");
    }

    public void setCommand(List<String> command) {
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, "sdm master: command: {0}", command.toString());
        this.command = command;
    }

    public void setWorkDir(String workDir) {
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, "sdm master: workdir: {0}", workDir);
        this.workDir = workDir;
    }

    public synchronized SDMMasterState getSdmState() {
        return this.sdmState;
    }

    protected synchronized void setSdmState(SDMMasterState sdmState) {
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, "sdm master: changed state to {0}", sdmState.toString());
        this.sdmState = sdmState;
        ((Object)((Object)this)).notifyAll();
    }

    public void setJob(IPJob ipJob) {
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, "sdm master: associated to job #{0}", ipJob.getID());
        this.ipJob = ipJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        assert (this.workDir != null);
        assert (this.command != null);
        assert (this.sdmProcess == null);
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "sdm master: thread started.");
        try {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            AbstractRemoteResourceManagerConfiguration configuration = (AbstractRemoteResourceManagerConfiguration)this.rmControl.getConfiguration();
            IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(configuration.getRemoteServicesId());
            IRemoteConnectionManager connectionManager = remoteServices.getConnectionManager();
            IRemoteConnection connection = connectionManager.getConnection(configuration.getConnectionName());
            IRemoteFileManager fileManager = remoteServices.getFileManager(connection);
            IFileStore directory = null;
            try {
                directory = fileManager.getResource((IPath)new Path(this.workDir), monitor);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), "Failed to determine working directory for master SDM.", (Throwable)e));
            }
            IRemoteProcessBuilder sdmProcessBuilder = remoteServices.getProcessBuilder(connection, this.command);
            sdmProcessBuilder.directory(directory);
            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "sdm master: waiting for SDM servers and front end.");
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            SDMRunner sDMRunner = this;
            synchronized (sDMRunner) {
                ((Object)((Object)this)).wait(3000L);
            }
            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "sdm master: create process");
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            sDMRunner = this;
            synchronized (sDMRunner) {
                this.sdmProcess = sdmProcessBuilder.start();
            }
            final BufferedReader err_reader = new BufferedReader(new InputStreamReader(this.sdmProcess.getErrorStream()));
            final BufferedReader out_reader = new BufferedReader(new InputStreamReader(this.sdmProcess.getInputStream()));
            if (DebugUtil.SDM_MASTER_OUTPUT_TRACING) {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String output;
                            while ((output = out_reader.readLine()) != null) {
                                System.out.println("sdm master: " + output);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }, "sdm master standard output thread").start();
            }
            if (DebugUtil.SDM_MASTER_OUTPUT_TRACING) {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String line;
                            while ((line = err_reader.readLine()) != null) {
                                System.err.println("sdm master: " + line);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }, "sdm master error output thread").start();
            }
            this.setSdmState(SDMMasterState.RUNNING);
            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, "sdm master: waiting to finish.");
            while (!this.sdmProcess.isCompleted()) {
                SDMRunner sDMRunner2 = this;
                synchronized (sDMRunner2) {
                    ((Object)((Object)this)).wait(500L);
                }
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "sdm master: exit value {0}.", this.sdmProcess.exitValue());
            if (this.sdmProcess.exitValue() != 0) {
                if (!monitor.isCanceled()) {
                    throw new CoreException((IStatus)new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), NLS.bind((String)"sdm master process finished with exit code {0}.", (Object)this.sdmProcess.exitValue())));
                }
                DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "sdm master: ignoring exit code since requested to terminate.");
            }
            this.setSdmState(SDMMasterState.FINISHED);
            iStatus = Status.OK_STATUS;
        }
        catch (Exception e) {
            block49: {
                block48: {
                    IStatus iStatus2;
                    try {
                        DebugUtil.error(DebugUtil.SDM_MASTER_TRACING, "sdm master: exception: {0}", e);
                        this.setSdmState(SDMMasterState.ERROR);
                        SDMRunner remoteServices = this;
                        synchronized (remoteServices) {
                            DebugUtil.error(DebugUtil.SDM_MASTER_TRACING, "sdm master: destroy process", e);
                            this.sdmProcess.destroy();
                        }
                        try {
                            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "sdm master: request job {0} to terminate.", this.ipJob.getID());
                            this.rmControl.terminateJob(this.ipJob);
                        }
                        catch (CoreException e1) {
                            PTPDebugCorePlugin.log((Throwable)e1);
                        }
                        if (!(e instanceof InterruptedException)) break block48;
                        iStatus2 = Status.CANCEL_STATUS;
                    }
                    catch (Throwable throwable) {
                        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "sdm master: thread finished.");
                        SDMRunner sDMRunner = this;
                        synchronized (sDMRunner) {
                            this.sdmProcess = null;
                        }
                        throw throwable;
                    }
                    DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "sdm master: thread finished.");
                    SDMRunner sDMRunner = this;
                    synchronized (sDMRunner) {
                        this.sdmProcess = null;
                    }
                    return iStatus2;
                }
                if (!(e instanceof CoreException)) break block49;
                IStatus iStatus3 = ((CoreException)((Object)e)).getStatus();
                DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "sdm master: thread finished.");
                SDMRunner sDMRunner = this;
                synchronized (sDMRunner) {
                    this.sdmProcess = null;
                }
                return iStatus3;
            }
            Status status = new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), "Failed to launch sdm master process.", (Throwable)e);
            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "sdm master: thread finished.");
            SDMRunner sDMRunner = this;
            synchronized (sDMRunner) {
                this.sdmProcess = null;
            }
            return status;
        }
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "sdm master: thread finished.");
        SDMRunner sDMRunner = this;
        synchronized (sDMRunner) {
            this.sdmProcess = null;
        }
        return iStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void canceling() {
        SDMRunner sDMRunner = this;
        synchronized (sDMRunner) {
            if (this.sdmProcess != null) {
                this.sdmProcess.destroy();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SDMMasterState {
        UNKNOWN,
        STARTING,
        RUNNING,
        FINISHED,
        ERROR;

    }
}

