/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.osgi.framework.BundleContext;

public class UIPlugin
extends Plugin {
    private static UIPlugin fInstance = null;
    public static final String PLUGIN_ID = "org.eclipse.ptp.rdt.ui";
    public static final String TYPE_HIERARCHY_VIEW_ID = "org.eclipse.ptp.rdt.ui.typeHierarchy";
    public static final String CALL_HIERARCHY_VIEW_ID = "org.eclipse.ptp.rdt.ui.callHierarchy";
    public static final String INCLUDE_BROWSER_VIEW_ID = "org.eclipse.ptp.rdt.ui.includeBrowser";
    private static final String PREFERENCE_HAS_ALREADY_RUN = "org.eclipse.ptp.rdt.ui.hasRun";
    public static final String REMOTE_SEARCH_ACTION_SET_ID = "org.eclipse.ptp.rdt.ui.SearchActionSet";

    public UIPlugin() {
        fInstance = this;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        UIPlugin.turnOffIndexerAnnotations();
    }

    public static UIPlugin getDefault() {
        return fInstance;
    }

    private static void turnOffIndexerAnnotations() {
        Preferences preferences = EditorsPlugin.getDefault().getPluginPreferences();
        boolean hasAlreadyRun = preferences.getBoolean(PREFERENCE_HAS_ALREADY_RUN);
        if (!hasAlreadyRun) {
            preferences.setValue("indexResultIndicationInOverviewRuler", false);
            preferences.setValue("indexResultIndicationInVerticalRuler", false);
            preferences.setValue("indexResultIndication", false);
            preferences.setValue(PREFERENCE_HAS_ALREADY_RUN, true);
            EditorsPlugin.getDefault().savePluginPreferences();
        }
    }

    public static void log(Throwable e) {
        UIPlugin.log("Error", e);
    }

    public static void log(String message, Throwable e) {
        UIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, message, e));
    }

    public static void log(IStatus status) {
        UIPlugin.getDefault().getLog().log(status);
    }

    public void logErrorMessage(String message) {
        UIPlugin.log((IStatus)new Status(4, UIPlugin.getPluginId(), 10001, message, null));
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }
}

