/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.utils;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.rm.core.utils.IInputStreamListener;

public class InputStreamObserver
extends Thread {
    boolean closed = false;
    private InputStream input;
    private boolean killed;
    ListenerList listeners = new ListenerList();
    private static final int BUFFER_SIZE = 100;

    public InputStreamObserver(InputStream input) {
        this.input = input;
        this.setName(this.getClass().getName());
    }

    public InputStreamObserver(InputStream input, String name) {
        this.input = input;
        this.setName(name);
    }

    public InputStreamObserver(InputStream input, IInputStreamListener listener, String name) {
        this.input = input;
        this.listeners.add((Object)listener);
        this.setName(name);
    }

    public InputStreamObserver(InputStream input, IInputStreamListener listener) {
        this.input = input;
        this.listeners.add((Object)listener);
        this.setName(this.getClass().getName());
    }

    public synchronized void kill() {
        this.killed = true;
        this.interrupt();
    }

    protected void log(String s) {
    }

    protected void log(Throwable e) {
        PTPCorePlugin.log((Throwable)e);
    }

    void streamClosed() {
        if (this.closed) {
            return;
        }
        this.log("Stream closed");
        this.closed = true;
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((IInputStreamListener)listener).streamClosed();
            }
            catch (Exception e) {
                this.log(e);
                this.listeners.remove(listener);
            }
            ++n2;
        }
    }

    void streamError(Exception e) {
        if (this.closed) {
            return;
        }
        this.log("Recovered from exception: " + e.getMessage());
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((IInputStreamListener)listener).streamError(e);
            }
            catch (Exception ee) {
                this.log(ee);
                this.listeners.remove(listener);
            }
            ++n2;
        }
    }

    void newBytes(byte[] buffer, int length) {
        if (this.closed) {
            return;
        }
        this.log("Received: " + Integer.toString(length) + " bytes");
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((IInputStreamListener)listener).newBytes(buffer, length);
            }
            catch (Exception e) {
                this.log(e);
                this.listeners.remove(listener);
            }
            ++n2;
        }
    }

    public void run() {
        byte[] buffer = new byte[100];
        this.log("Started observing");
        while (!this.killed) {
            try {
                int bytes = this.input.read(buffer);
                if (bytes > 0) {
                    this.newBytes(buffer, bytes);
                    continue;
                }
                if (bytes != -1) continue;
                this.streamClosed();
            }
            catch (IOException e) {
                if (this.killed) {
                    this.streamClosed();
                    break;
                }
                if (e instanceof EOFException) {
                    this.streamClosed();
                    break;
                }
                this.streamError(e);
            }
            catch (NullPointerException e) {
                if (this.killed) {
                    this.streamClosed();
                    break;
                }
                this.streamError(e);
            }
            break;
        }
        this.log("Finished observing");
    }

    public void addListener(IInputStreamListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IInputStreamListener listener) {
        this.listeners.remove((Object)listener);
    }
}

