/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.ui.deploy.events;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.cell.environment.ui.deploy.debug.Debug;
import org.eclipse.ptp.cell.environment.ui.deploy.events.AbstractCellTargetJob;
import org.eclipse.ptp.cell.environment.ui.deploy.events.Messages;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.ITargetJob;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;

public class DeleteJobWrapper
implements IRunnableWithProgress {
    private ITargetControl cellControl;
    private String path;

    public void init(ITargetControl control, String p) {
        Debug.POLICY.pass(Debug.DEBUG_JOBS, control.toString(), new Object[]{p});
        this.cellControl = control;
        this.path = p;
    }

    public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Debug.POLICY.enter(Debug.DEBUG_JOBS);
        monitor.beginTask(Messages.DeleteJobWrapper_0, 1);
        monitor.subTask(String.valueOf(Messages.DeleteJobWrapper_1) + this.path);
        if (monitor.isCanceled()) {
            throw new InterruptedException(Messages.DeleteJobWrapper_2);
        }
        AbstractCellTargetJob deleteJob = new AbstractCellTargetJob(){

            public void run() {
                Debug.POLICY.enter(Debug.DEBUG_JOBS);
                try {
                    IRemoteFileTools fileTools = this.executionManager.getRemoteFileTools();
                    if (monitor.isCanceled()) {
                        throw new InterruptedException(Messages.DeleteJobWrapper_3);
                    }
                    if (!fileTools.hasFile(DeleteJobWrapper.this.path) && !fileTools.hasDirectory(DeleteJobWrapper.this.path)) {
                        throw new InvocationTargetException(null, Messages.DeleteJobWrapper_4);
                    }
                    fileTools.removeFile(DeleteJobWrapper.this.path);
                    monitor.worked(1);
                }
                catch (RemoteConnectionException e) {
                    Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
                    this.exception = e;
                    this.errorMessage = Messages.DeleteJobWrapper_5;
                    this.hadError = true;
                }
                catch (RemoteOperationException e) {
                    Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
                    this.exception = e;
                    this.errorMessage = Messages.DeleteJobWrapper_6;
                    this.hadError = true;
                }
                catch (CancelException e) {
                    Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
                    this.exception = e;
                    this.errorMessage = Messages.DeleteJobWrapper_7;
                    this.hadError = true;
                }
                catch (InvocationTargetException e) {
                    Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
                    this.exception = e;
                    this.hadError = true;
                }
                catch (InterruptedException e) {
                    Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
                    this.exception = e;
                    this.hadError = true;
                }
                Debug.POLICY.exit(Debug.DEBUG_JOBS);
            }
        };
        try {
            try {
                this.cellControl.startJob((ITargetJob)deleteJob);
                deleteJob.waitFor(monitor, Messages.DeleteJobWrapper_8);
                if (deleteJob.didHaveError()) {
                    Exception exception = deleteJob.getException();
                    if (exception instanceof InterruptedException) {
                        throw (InterruptedException)exception;
                    }
                    if (exception instanceof InvocationTargetException) {
                        throw (InvocationTargetException)exception;
                    }
                    throw new InvocationTargetException(deleteJob.getException(), deleteJob.getErrorMessage());
                }
            }
            catch (CoreException e) {
                Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
                throw new InvocationTargetException(e, Messages.DeleteJobWrapper_9);
            }
        }
        finally {
            monitor.done();
        }
        Debug.POLICY.exit(Debug.DEBUG_JOBS);
    }
}

