/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.ptp.internal.rdt.core.IRemoteIndexerInfoProvider;
import org.eclipse.ptp.internal.rdt.core.RemoteScannerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteIndexerInfoProvider
implements IRemoteIndexerInfoProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, RemoteScannerInfo> pathMap;
    private final Map<Integer, RemoteScannerInfo> linkageMap;
    private final Map<String, String> languageMap;
    private final Map<String, Boolean> isHeaderMap;
    private final Map<String, Boolean> indexerPreferences;
    private final List<String> filesToParseUpFront;

    RemoteIndexerInfoProvider(Map<String, RemoteScannerInfo> pathMap, Map<Integer, RemoteScannerInfo> linkageMap, Map<String, String> languageMap, Map<String, Boolean> isHeaderMap, Map<String, Boolean> indexerPreferences, List<String> filesToParseUpFront) {
        this.pathMap = pathMap == null ? Collections.emptyMap() : pathMap;
        this.linkageMap = linkageMap == null ? Collections.emptyMap() : linkageMap;
        this.languageMap = languageMap == null ? Collections.emptyMap() : languageMap;
        this.isHeaderMap = isHeaderMap == null ? Collections.emptyMap() : isHeaderMap;
        this.indexerPreferences = indexerPreferences == null ? Collections.emptyMap() : indexerPreferences;
        this.filesToParseUpFront = filesToParseUpFront == null ? Collections.emptyList() : filesToParseUpFront;
    }

    RemoteIndexerInfoProvider() {
        this.pathMap = Collections.emptyMap();
        this.linkageMap = Collections.emptyMap();
        this.languageMap = Collections.emptyMap();
        this.isHeaderMap = Collections.emptyMap();
        this.indexerPreferences = Collections.emptyMap();
        this.filesToParseUpFront = Collections.emptyList();
    }

    public IScannerInfo getScannerInformation(String path) {
        return RemoteIndexerInfoProvider.getScannerInfo(this.pathMap, path);
    }

    public IScannerInfo getDefaultScannerInformation(int linkageId) {
        return RemoteIndexerInfoProvider.getScannerInfo(this.linkageMap, linkageId);
    }

    private static <T> IScannerInfo getScannerInfo(Map<T, RemoteScannerInfo> map, T key) {
        IScannerInfo si = map.get(key);
        return si == null ? new RemoteScannerInfo() : si;
    }

    @Override
    public String getLanguageID(String path) {
        return this.languageMap.get(path);
    }

    @Override
    public boolean isHeaderUnit(String path) {
        return this.isHeaderMap.get(path);
    }

    @Override
    public Map<String, Boolean> getIndexerPreferences() {
        return Collections.unmodifiableMap(this.indexerPreferences);
    }

    @Override
    public List<String> getFilesToParseUpFront() {
        return Collections.unmodifiableList(this.filesToParseUpFront);
    }

    public String toString() {
        return "pathMap:" + this.pathMap + " linkageMap:" + this.linkageMap + " languageMap:" + this.languageMap + " isHeaderMap:" + this.isHeaderMap + " preferences: " + this.indexerPreferences;
    }
}

