/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.BufferChangedEvent;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.dom.NullCodeReaderFactory;
import org.eclipse.cdt.internal.core.index.IndexBasedCodeReaderFactory;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.pdom.ASTFilePathResolver;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.RemoteIndexerInputAdapter;
import org.eclipse.ptp.internal.rdt.core.miners.StandaloneSavedCodeReaderFactory;
import org.eclipse.ptp.internal.rdt.core.model.CProject;
import org.eclipse.ptp.internal.rdt.core.model.Parent;

public class TranslationUnit
extends Parent
implements ITranslationUnit {
    private static final long serialVersionUID = 1L;
    Class<? extends ILanguage> fLanguageClass;
    protected transient ILanguage fLanguage;
    private IScannerInfo fScannerInfo;
    private boolean isHeaderUnit = false;

    public TranslationUnit(ICElement parent, String name, String projectName, URI locationURI) {
        super(parent, 60, name);
        if (projectName == null || locationURI == null) {
            throw new IllegalArgumentException();
        }
        this.setCProject(new CProject(projectName));
        this.fLocation = locationURI;
    }

    public TranslationUnit(Parent parent, ITranslationUnit element) {
        super(parent, element.getElementType(), element.getElementName());
        ICProject project = element.getCProject();
        if (project instanceof CProject) {
            this.setCProject(project);
        } else if (project != null) {
            this.setCProject(new CProject(project.getElementName()));
        } else {
            throw new IllegalArgumentException();
        }
        try {
            this.setLanguage(element.getLanguage());
        }
        catch (CoreException e) {
            throw new IllegalArgumentException(e);
        }
        this.setLocationURI(element.getLocationURI());
        this.isHeaderUnit = element.isHeaderUnit();
    }

    public IInclude createInclude(String name, boolean isStd, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public INamespace createNamespace(String namespace, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public IUsing createUsing(String name, boolean isDirective, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public IWorkingCopy findSharedWorkingCopy(IBufferFactory bufferFactory) {
        return null;
    }

    public IASTTranslationUnit getAST() throws CoreException {
        return this.getAST(null, 0);
    }

    public void setASTContext(IScannerInfo scannerInfo) {
        this.fScannerInfo = scannerInfo;
    }

    public void setLanguage(ILanguage language) {
        this.fLanguage = language;
        this.fLanguageClass = language == null ? null : language.getClass();
    }

    private ICodeReaderFactory getCodeReaderFactory(int style, IIndex index, int linkageID) {
        RemoteIndexerInputAdapter pathResolver = new RemoteIndexerInputAdapter();
        Object codeReaderFactory = (style & 4) != 0 ? NullCodeReaderFactory.getInstance() : StandaloneSavedCodeReaderFactory.getInstance();
        if (index != null && (style & 2) != 0) {
            IndexBasedCodeReaderFactory ibcf = new IndexBasedCodeReaderFactory(index, (ASTFilePathResolver)pathResolver, linkageID, codeReaderFactory);
            if ((style & 0x20) != 0) {
                ibcf.setSupportFillGapFromContextToHeader(true);
            }
            codeReaderFactory = ibcf;
        }
        return codeReaderFactory;
    }

    public IASTTranslationUnit getAST(IIndex index, int style) throws CoreException {
        ILanguage language;
        this.checkState();
        IScannerInfo scanInfo = this.getScannerInfo(true);
        if (scanInfo == null) {
            return null;
        }
        CodeReader reader = this.getCodeReader();
        if (reader != null && (language = this.getLanguage()) != null) {
            ICodeReaderFactory crf = this.getCodeReaderFactory(style, index, language.getLinkageID());
            int options = 0;
            if ((style & 1) != 0) {
                options |= 1;
            }
            if ((style & 0x10) != 0) {
                options |= 2;
            }
            if ((style & 0x40) != 0) {
                options |= 0x10;
            }
            if (this.isSourceUnit()) {
                options |= 8;
            }
            DefaultLogService log = new DefaultLogService();
            return ((AbstractLanguage)language).getASTTranslationUnit(reader, scanInfo, crf, index, options, (IParserLogService)log);
        }
        return null;
    }

    public int getParserOptions(String filePath) {
        if (filePath.endsWith(".cpp") || filePath.endsWith(".C") || filePath.endsWith(".c")) {
            return 8;
        }
        return 0;
    }

    public CodeReader getCodeReader() {
        if (this.fLocation == null) {
            return null;
        }
        String filePath = this.fLocation.getPath();
        try {
            return new CodeReader(filePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IASTCompletionNode getCompletionNode(IIndex index, int style, int offset) throws CoreException {
        this.checkState();
        IScannerInfo scanInfo = this.getScannerInfo(true);
        if (scanInfo == null) {
            return null;
        }
        CodeReader reader = this.getCodeReader();
        ILanguage language = this.getLanguage();
        if (language != null) {
            ICodeReaderFactory crf = this.getCodeReaderFactory(style, index, language.getLinkageID());
            DefaultLogService log = new DefaultLogService();
            return language.getCompletionNode(reader, scanInfo, crf, index, (IParserLogService)log, offset);
        }
        return null;
    }

    public String getContentTypeId() {
        return null;
    }

    public char[] getContents() {
        return new char[0];
    }

    public ICElement getElement(String name) throws CModelException {
        return null;
    }

    public ICElement getElementAtLine(int line) throws CModelException {
        return null;
    }

    public ICElement getElementAtOffset(int offset) throws CModelException {
        return null;
    }

    public ICElement[] getElementsAtOffset(int offset) throws CModelException {
        return null;
    }

    public IInclude getInclude(String name) {
        try {
            ICElement[] celements;
            ICElement[] iCElementArray = celements = this.getChildren();
            int n = celements.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement celement = iCElementArray[n2];
                if (celement.getElementType() == 75 && name.equals(celement.getElementName())) {
                    return (IInclude)celement;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public IInclude[] getIncludes() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        ICElement[] iCElementArray = celements;
        int n = celements.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement celement = iCElementArray[n2];
            if (celement.getElementType() == 75) {
                aList.add(celement);
            }
            ++n2;
        }
        return aList.toArray(new IInclude[0]);
    }

    public ILanguage getLanguage() throws CoreException {
        this.checkState();
        return this.fLanguage;
    }

    public IPath getLocation() {
        return null;
    }

    public INamespace getNamespace(String name) {
        return null;
    }

    public INamespace[] getNamespaces() throws CModelException {
        return null;
    }

    public IScannerInfo getScannerInfo(boolean force) {
        return this.fScannerInfo;
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        return null;
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory, IProblemRequestor requestor) throws CModelException {
        return null;
    }

    public IUsing getUsing(String name) {
        return null;
    }

    public IUsing[] getUsings() throws CModelException {
        return null;
    }

    public IWorkingCopy getWorkingCopy() throws CModelException {
        return null;
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        return null;
    }

    public boolean isASMLanguage() {
        return false;
    }

    public boolean isCLanguage() {
        return false;
    }

    public boolean isCXXLanguage() {
        return false;
    }

    public boolean isHeaderUnit() {
        return this.isHeaderUnit;
    }

    public boolean isSourceUnit() {
        return !this.isHeaderUnit;
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public Map parse() {
        return null;
    }

    public void setIsStructureKnown(boolean wasSuccessful) {
    }

    public void close() throws CModelException {
    }

    public IBuffer getBuffer() throws CModelException {
        return null;
    }

    public boolean hasUnsavedChanges() throws CModelException {
        return false;
    }

    public boolean isConsistent() throws CModelException {
        return false;
    }

    public boolean isOpen() {
        return false;
    }

    public void makeConsistent(IProgressMonitor progress) throws CModelException {
    }

    public void makeConsistent(IProgressMonitor progress, boolean forced) throws CModelException {
    }

    public void open(IProgressMonitor progress) throws CModelException {
    }

    public void save(IProgressMonitor progress, boolean force) throws CModelException {
    }

    public void bufferChanged(BufferChangedEvent event) {
    }

    public String getSource() throws CModelException {
        return null;
    }

    public ISourceRange getSourceRange() throws CModelException {
        return null;
    }

    public ITranslationUnit getTranslationUnit() {
        return null;
    }

    public void copy(ICElement container, ICElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws CModelException {
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
    }

    public void move(ICElement container, ICElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws CModelException {
    }

    public void rename(String name, boolean replace, IProgressMonitor monitor) throws CModelException {
    }

    public IProblemRequestor getProblemRequestor() {
        return null;
    }

    private void checkState() {
        if (this.fLanguage == null && this.fLanguageClass != null) {
            try {
                this.fLanguage = this.fLanguageClass.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

