/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.simulator.internal;

import org.eclipse.ptp.cell.simulator.core.SimulatorException;
import org.eclipse.ptp.cell.simulator.core.SimulatorTerminatedException;

public class Semaphore {
    boolean isOpen = false;
    SimulatorException error = null;

    public synchronized void waitToOpen(int time) throws SimulatorException {
        if (this.isOpen) {
            return;
        }
        if (this.error != null) {
            throw this.error;
        }
        try {
            this.wait(time);
        }
        catch (InterruptedException interruptedException) {
            throw new SimulatorTerminatedException();
        }
        if (this.error != null) {
            throw this.error;
        }
    }

    public synchronized void waitToOpen() throws SimulatorException {
        try {
            while (!this.isOpen) {
                if (this.error != null) {
                    throw this.error;
                }
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new SimulatorTerminatedException();
        }
    }

    public synchronized void open() {
        this.isOpen = true;
        this.notifyAll();
    }

    public synchronized void open(SimulatorException e) {
        this.error = e;
        this.notifyAll();
    }

    public synchronized boolean isOpen() {
        return this.isOpen;
    }

    public synchronized void reset() {
        this.isOpen = false;
        this.error = null;
    }
}

