/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.typehierarchy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.THGraphEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class THGraphNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<THGraphEdge> fOutgoing = Collections.emptyList();
    private List<THGraphEdge> fIncoming = Collections.emptyList();
    private ICElement fElement;
    private ICElement[] fMembers = null;

    public THGraphNode(ICElement element) {
        this.fElement = element;
    }

    public void startEdge(THGraphEdge outgoing) {
        this.fOutgoing = this.addElement(this.fOutgoing, outgoing);
    }

    public void endEdge(THGraphEdge incoming) {
        this.fIncoming = this.addElement(this.fIncoming, incoming);
    }

    public ICElement getElement() {
        return this.fElement;
    }

    private List<THGraphEdge> addElement(List<THGraphEdge> list, THGraphEdge elem) {
        switch (list.size()) {
            case 0: {
                return Collections.singletonList(elem);
            }
            case 1: {
                list = new ArrayList<THGraphEdge>(list);
                list.add(elem);
                return list;
            }
        }
        list.add(elem);
        return list;
    }

    public List<THGraphEdge> getOutgoing() {
        return this.fOutgoing;
    }

    public List<THGraphEdge> getIncoming() {
        return this.fIncoming;
    }

    public void setMembers(ICElement[] array) {
        this.fMembers = array;
    }

    public ICElement[] getMembers(boolean addInherited) {
        if (!addInherited) {
            return this.fMembers;
        }
        ArrayList<ICElement> list = new ArrayList<ICElement>();
        this.collectMembers(new HashSet<THGraphNode>(), list);
        return list.toArray(new ICElement[list.size()]);
    }

    private void collectMembers(HashSet<THGraphNode> visited, List<ICElement> list) {
        if (visited.add(this)) {
            if (this.fMembers != null) {
                list.addAll((Collection<ICElement>)Arrays.asList(this.fMembers));
            }
            List<THGraphEdge> bases = this.getOutgoing();
            for (THGraphEdge edge : bases) {
                edge.getEndNode().collectMembers(visited, list);
            }
        }
    }

    public String toString() {
        return this.fElement == null ? null : this.fElement.toString();
    }
}

