/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.index.IIndexScope;

public class CPPNamespaceScope
extends CPPScope
implements ICPPNamespaceScope {
    ICPPUsingDirective[] usings = null;

    public CPPNamespaceScope(IASTNode physicalNode) {
        super(physicalNode);
    }

    public ICPPUsingDirective[] getUsingDirectives() throws DOMException {
        if (!this.isFullyCached()) {
            CPPSemantics.lookupInScope(null, this, null);
        }
        return (ICPPUsingDirective[])ArrayUtil.trim(ICPPUsingDirective.class, this.usings, true);
    }

    public void addUsingDirective(ICPPUsingDirective directive) {
        this.usings = (ICPPUsingDirective[])ArrayUtil.append(ICPPUsingDirective.class, this.usings, directive);
    }

    public IName getScopeName() {
        IASTNode node = this.getPhysicalNode();
        if (node instanceof ICPPASTNamespaceDefinition) {
            return ((ICPPASTNamespaceDefinition)node).getName();
        }
        return null;
    }

    public IScope findNamespaceScope(IIndexScope scope) {
        final String[] qname = scope.getScopeBinding().getQualifiedName();
        final IScope[] result = new IScope[1];
        CPPASTVisitor visitor = new CPPASTVisitor(){
            private int depth = 0;
            {
                this.shouldVisitDeclarations = true;
                this.shouldVisitNamespaces = true;
            }

            public int visit(IASTDeclaration declaration) {
                if (declaration instanceof ICPPASTLinkageSpecification) {
                    return 3;
                }
                return 1;
            }

            public int visit(ICPPASTNamespaceDefinition namespace) {
                String name = namespace.getName().toString();
                if (name.length() == 0) {
                    return 3;
                }
                if (qname[this.depth].equals(name)) {
                    if (++this.depth == qname.length) {
                        result[0] = namespace.getScope();
                        return 2;
                    }
                    return 3;
                }
                return 1;
            }

            public int leave(ICPPASTNamespaceDefinition namespace) {
                if (namespace.getName().toCharArray().length > 0) {
                    --this.depth;
                }
                return 3;
            }
        };
        this.getPhysicalNode().accept(visitor);
        return result[0];
    }
}

