/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;

public class CPPUnknownClassInstance
extends CPPUnknownClass
implements ICPPUnknownClassInstance {
    private final IType[] arguments;

    public CPPUnknownClassInstance(ICPPUnknownBinding scopeBinding, IASTName name, IType[] arguments) {
        super(scopeBinding, name);
        this.arguments = arguments;
    }

    public IType[] getArguments() {
        return this.arguments;
    }

    public IBinding resolvePartially(ICPPUnknownBinding parentBinding, ObjectMap argMap, ICPPScope instantiationScope) {
        IType[] newArgs = CPPTemplates.instantiateTypes(this.arguments, argMap, instantiationScope);
        if (parentBinding == this.unknownContainerBinding && newArgs == this.arguments) {
            return this;
        }
        return new CPPUnknownClassInstance(parentBinding, this.name, newArgs);
    }

    public String toString() {
        return String.valueOf(this.getName()) + " <" + ASTTypeUtil.getTypeListString(this.arguments) + ">";
    }

    public boolean isSameType(IType type) {
        if (this == type) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof ICPPUnknownClassInstance) {
            ICPPUnknownClassInstance rhs = (ICPPUnknownClassInstance)type;
            if (CharArrayUtils.equals(this.getNameCharArray(), rhs.getNameCharArray())) {
                IType[] rhsArgs;
                IType[] lhsArgs = this.getArguments();
                if (lhsArgs != (rhsArgs = rhs.getArguments())) {
                    if (lhsArgs == null || rhsArgs == null) {
                        return false;
                    }
                    if (lhsArgs.length != rhsArgs.length) {
                        return false;
                    }
                    int i = 0;
                    while (i < lhsArgs.length) {
                        if (!CPPTemplates.isSameTemplateArgument(lhsArgs[i], rhsArgs[i])) {
                            return false;
                        }
                        ++i;
                    }
                }
                ICPPUnknownBinding lhsContainer = this.getUnknownContainerBinding();
                ICPPUnknownBinding rhsContainer = rhs.getUnknownContainerBinding();
                if (lhsContainer instanceof IType && rhsContainer instanceof IType) {
                    return ((IType)((Object)lhsContainer)).isSameType((IType)((Object)rhsContainer));
                }
            }
        }
        return false;
    }
}

