/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTBaseDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.c.CCompositeTypeScope;

public class CASTCompositeTypeSpecifier
extends CASTBaseDeclSpecifier
implements ICASTCompositeTypeSpecifier {
    private int key;
    private IASTName name;
    private IASTDeclaration[] declarations = null;
    private int declarationsPos = -1;
    private IScope scope = null;

    public CASTCompositeTypeSpecifier() {
    }

    public CASTCompositeTypeSpecifier(int key, IASTName name) {
        this.key = key;
        this.setName(name);
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    public IASTName getName() {
        return this.name;
    }

    public void setName(IASTName name) {
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(TYPE_NAME);
        }
    }

    public IASTDeclaration[] getMembers() {
        if (this.declarations == null) {
            return IASTDeclaration.EMPTY_DECLARATION_ARRAY;
        }
        this.declarations = (IASTDeclaration[])ArrayUtil.removeNullsAfter(IASTDeclaration.class, this.declarations, this.declarationsPos);
        return this.declarations;
    }

    public void addMemberDeclaration(IASTDeclaration declaration) {
        if (declaration != null) {
            declaration.setParent(this);
            declaration.setPropertyInParent(MEMBER_DECLARATION);
            this.declarations = (IASTDeclaration[])ArrayUtil.append(IASTDeclaration.class, this.declarations, ++this.declarationsPos, declaration);
        }
    }

    public IScope getScope() {
        if (this.scope == null) {
            this.scope = new CCompositeTypeScope(this);
        }
        return this.scope;
    }

    public String getRawSignature() {
        return this.getName().toString() == null ? "" : this.getName().toString();
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        IASTDeclaration[] decls = this.getMembers();
        int i = 0;
        while (i < decls.length) {
            if (!decls[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 2;
        }
        return 3;
    }
}

