/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTBinaryExpression
extends CPPASTNode
implements ICPPASTBinaryExpression,
IASTAmbiguityParent {
    private int op;
    private IASTExpression operand1;
    private IASTExpression operand2;
    private IType type;

    public CPPASTBinaryExpression() {
    }

    public CPPASTBinaryExpression(int op, IASTExpression operand1, IASTExpression operand2) {
        this.op = op;
        this.setOperand1(operand1);
        this.setOperand2(operand2);
    }

    public int getOperator() {
        return this.op;
    }

    public IASTExpression getOperand1() {
        return this.operand1;
    }

    public IASTExpression getOperand2() {
        return this.operand2;
    }

    public void setOperator(int op) {
        this.op = op;
    }

    public void setOperand1(IASTExpression expression) {
        this.operand1 = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND_ONE);
        }
    }

    public void setOperand2(IASTExpression expression) {
        this.operand2 = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND_TWO);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.operand1 != null && !this.operand1.accept(action)) {
            return false;
        }
        if (this.operand2 != null && !this.operand2.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.operand1) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand1 = (IASTExpression)other;
        }
        if (child == this.operand2) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand2 = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        if (this.type == null) {
            this.type = CPPVisitor.getExpressionType(this);
        }
        return this.type;
    }
}

