/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public final class PDOMMacroReferenceName
implements IIndexFragmentName,
IASTFileLocation {
    private final PDOM pdom;
    private final int record;
    private static final int FILE_REC_OFFSET = 0;
    private static final int FILE_NEXT_OFFSET = 4;
    private static final int CONTAINER_REC_OFFSET = 8;
    private static final int CONTAINER_PREV_OFFSET = 12;
    private static final int CONTAINER_NEXT_OFFSET = 16;
    private static final int NODE_OFFSET_OFFSET = 20;
    private static final int NODE_LENGTH_OFFSET = 24;
    private static final int RECORD_SIZE = 26;

    public PDOMMacroReferenceName(PDOM pdom, IASTName name, PDOMFile file, PDOMMacroContainer container) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(26);
        db.putInt(this.record + 8, container.getRecord());
        db.putInt(this.record + 0, file.getRecord());
        IASTFileLocation fileloc = name.getFileLocation();
        db.putInt(this.record + 20, fileloc.getNodeOffset());
        db.putShort(this.record + 24, (short)fileloc.getNodeLength());
        container.addReference(this);
    }

    public PDOMMacroReferenceName(PDOM pdom, int nameRecord) {
        this.pdom = pdom;
        this.record = nameRecord;
    }

    public int getRecord() {
        return this.record;
    }

    private int getRecField(int offset) throws CoreException {
        return this.pdom.getDB().getInt(this.record + offset);
    }

    private void setRecField(int offset, int fieldrec) throws CoreException {
        this.pdom.getDB().putInt(this.record + offset, fieldrec);
    }

    public PDOMMacroContainer getContainer() throws CoreException {
        int bindingrec = this.getRecField(8);
        return new PDOMMacroContainer(this.pdom, bindingrec);
    }

    private PDOMMacroReferenceName getNameField(int offset) throws CoreException {
        int namerec = this.getRecField(offset);
        return namerec != 0 ? new PDOMMacroReferenceName(this.pdom, namerec) : null;
    }

    private void setNameField(int offset, PDOMMacroReferenceName name) throws CoreException {
        int namerec = name != null ? name.getRecord() : 0;
        this.setRecField(offset, namerec);
    }

    PDOMMacroReferenceName getPrevInContainer() throws CoreException {
        return this.getNameField(12);
    }

    void setPrevInContainer(PDOMMacroReferenceName name) throws CoreException {
        this.setNameField(12, name);
    }

    public PDOMMacroReferenceName getNextInContainer() throws CoreException {
        return this.getNameField(16);
    }

    void setNextInContainer(PDOMMacroReferenceName name) throws CoreException {
        this.setNameField(16, name);
    }

    public PDOMFile getFile() throws CoreException {
        int filerec = this.pdom.getDB().getInt(this.record + 0);
        return filerec != 0 ? new PDOMFile(this.pdom, filerec) : null;
    }

    PDOMMacroReferenceName getNextInFile() throws CoreException {
        return this.getNameField(4);
    }

    void setNextInFile(PDOMMacroReferenceName name) throws CoreException {
        this.setNameField(4, name);
    }

    public char[] toCharArray() {
        try {
            return this.getContainer().getNameCharArray();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return CharArrayUtils.EMPTY;
        }
    }

    public String toString() {
        return new String(this.toCharArray());
    }

    public boolean isBaseSpecifier() throws CoreException {
        return false;
    }

    public boolean couldBePolymorphicMethodCall() throws CoreException {
        return false;
    }

    public boolean isReadAccess() throws CoreException {
        return false;
    }

    public boolean isWriteAccess() throws CoreException {
        return false;
    }

    public boolean isDeclaration() {
        return false;
    }

    public boolean isReference() {
        return true;
    }

    public boolean isDefinition() {
        return false;
    }

    public IASTFileLocation getFileLocation() {
        return this;
    }

    public String getFileName() {
        PDOMFile file;
        block3: {
            try {
                file = this.getFile();
                if (file != null) break block3;
                return null;
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                return null;
            }
        }
        IPath location = IndexLocationFactory.getAbsolutePath(file.getLocation());
        return location != null ? location.toOSString() : null;
    }

    public int getStartingLineNumber() {
        return 0;
    }

    public int getEndingLineNumber() {
        return 0;
    }

    public IASTFileLocation asFileLocation() {
        return this;
    }

    public int getNodeLength() {
        try {
            return this.pdom.getDB().getShort(this.record + 24) & 0xFFFF;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return 0;
        }
    }

    public int getNodeOffset() {
        try {
            return this.pdom.getDB().getInt(this.record + 20);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return 0;
        }
    }

    public void delete() throws CoreException {
        PDOMMacroReferenceName prevName = this.getPrevInContainer();
        PDOMMacroReferenceName nextName = this.getNextInContainer();
        if (prevName != null) {
            prevName.setNextInContainer(nextName);
        } else {
            this.getContainer().setFirstReference(nextName);
        }
        if (nextName != null) {
            nextName.setPrevInContainer(prevName);
        }
        this.pdom.getDB().free(this.record);
    }

    public IIndexFragment getIndexFragment() {
        return this.pdom;
    }

    public IIndexName[] getEnclosedNames() throws CoreException {
        return IIndexName.EMPTY_ARRAY;
    }

    public IIndexFragmentBinding getBinding() throws CoreException {
        return this.getContainer();
    }

    public IIndexName getEnclosingDefinition() throws CoreException {
        return null;
    }
}

