/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;

public abstract class VariableReadWriteFlags {
    protected static final int READ = 16;
    protected static final int WRITE = 32;

    protected VariableReadWriteFlags() {
    }

    protected int rwAnyNode(IASTNode node, int indirection) {
        IASTNode parent = node.getParent();
        if (parent instanceof IASTExpression) {
            return this.rwInExpression(node, (IASTExpression)parent, indirection);
        }
        if (parent instanceof IASTStatement) {
            return this.rwInStatement(node, (IASTStatement)parent, indirection);
        }
        if (parent instanceof IASTInitializerExpression) {
            return this.rwInInitializerExpression(indirection, parent);
        }
        if (parent instanceof IASTArrayModifier) {
            return 16;
        }
        return 48;
    }

    protected int rwInInitializerExpression(int indirection, IASTNode parent) {
        try {
            IBinding binding;
            IASTNode grand = parent.getParent();
            if (grand instanceof IASTDeclarator && (binding = ((IASTDeclarator)grand).getName().getBinding()) instanceof IVariable) {
                return this.rwAssignmentToType(((IVariable)binding).getType(), indirection);
            }
        }
        catch (DOMException dOMException) {}
        return 48;
    }

    protected int rwInExpression(IASTNode node, IASTExpression expr, int indirection) {
        if (expr instanceof IASTBinaryExpression) {
            return this.rwInBinaryExpression(node, (IASTBinaryExpression)expr, indirection);
        }
        if (expr instanceof IASTUnaryExpression) {
            return this.rwInUnaryExpression(node, (IASTUnaryExpression)expr, indirection);
        }
        if (expr instanceof IASTArraySubscriptExpression) {
            if (indirection > 0 && node.getPropertyInParent() == IASTArraySubscriptExpression.ARRAY) {
                return this.rwAnyNode(expr, indirection - 1);
            }
            return 16;
        }
        if (expr instanceof IASTCastExpression) {
            return this.rwAnyNode(expr, indirection);
        }
        if (expr instanceof IASTConditionalExpression) {
            if (node.getPropertyInParent() == IASTConditionalExpression.LOGICAL_CONDITION) {
                return 16;
            }
            return this.rwAnyNode(expr, indirection);
        }
        if (expr instanceof IASTExpressionList) {
            IASTExpressionList exprList = (IASTExpressionList)expr;
            IASTNode grand = expr.getParent();
            if (grand instanceof IASTFunctionCallExpression && expr.getPropertyInParent() == IASTFunctionCallExpression.PARAMETERS) {
                IASTFunctionCallExpression funcCall = (IASTFunctionCallExpression)grand;
                return this.rwArgumentForFunctionCall(node, exprList, funcCall, indirection);
            }
            IASTExpression[] expressions = exprList.getExpressions();
            if (expressions.length > 0 && expressions[0] == node) {
                return this.rwAnyNode(expr, indirection);
            }
            return 0;
        }
        if (expr instanceof IASTFieldReference) {
            if (node.getPropertyInParent() == IASTFieldReference.FIELD_NAME) {
                return this.rwAnyNode(expr, indirection);
            }
            return 16;
        }
        if (expr instanceof IASTFunctionCallExpression) {
            if (node.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME) {
                return 16;
            }
            return this.rwArgumentForFunctionCall((IASTFunctionCallExpression)expr, 0, indirection);
        }
        if (expr instanceof IASTIdExpression) {
            return this.rwAnyNode(expr, indirection);
        }
        if (expr instanceof IASTProblemExpression) {
            return 48;
        }
        if (expr instanceof IASTTypeIdExpression) {
            return 0;
        }
        return 48;
    }

    protected int rwArgumentForFunctionCall(IASTNode node, IASTExpressionList exprList, IASTFunctionCallExpression funcCall, int indirection) {
        IASTExpression[] expressions = exprList.getExpressions();
        int i = 0;
        while (i < expressions.length) {
            if (expressions[i] == node) {
                return this.rwArgumentForFunctionCall(funcCall, i, indirection);
            }
            ++i;
        }
        return 48;
    }

    protected int rwArgumentForFunctionCall(IASTFunctionCallExpression func, int parameterIdx, int indirection) {
        try {
            IType[] ptypes;
            IType type;
            IASTExpression functionNameExpression = func.getFunctionNameExpression();
            if (functionNameExpression != null && (type = functionNameExpression.getExpressionType()) instanceof IFunctionType && (ptypes = ((IFunctionType)type).getParameterTypes()) != null && ptypes.length > parameterIdx) {
                return this.rwAssignmentToType(ptypes[parameterIdx], indirection);
            }
        }
        catch (DOMException dOMException) {}
        return 48;
    }

    protected abstract int rwAssignmentToType(IType var1, int var2);

    protected int rwInStatement(IASTNode node, IASTStatement stmt, int indirection) {
        if (stmt instanceof IASTCaseStatement) {
            if (node.getPropertyInParent() == IASTCaseStatement.EXPRESSION) {
                return 16;
            }
        } else if (stmt instanceof IASTDoStatement) {
            if (node.getPropertyInParent() == IASTDoStatement.CONDITION) {
                return 16;
            }
        } else if (stmt instanceof IASTExpressionStatement) {
            IASTNode parent = stmt.getParent();
            while (parent instanceof IASTCompoundStatement) {
                IASTCompoundStatement compound = (IASTCompoundStatement)parent;
                IASTStatement[] statements = compound.getStatements();
                if (statements[statements.length - 1] != stmt) {
                    return 0;
                }
                stmt = compound;
                parent = stmt.getParent();
            }
            if (parent instanceof IGNUASTCompoundStatementExpression) {
                return this.rwAnyNode(parent, indirection);
            }
        } else if (stmt instanceof IASTForStatement) {
            if (node.getPropertyInParent() == IASTForStatement.CONDITION) {
                return 16;
            }
        } else if (stmt instanceof IASTIfStatement) {
            if (node.getPropertyInParent() == IASTIfStatement.CONDITION) {
                return 16;
            }
        } else {
            if (stmt instanceof IASTProblemStatement) {
                return 48;
            }
            if (stmt instanceof IASTReturnStatement) {
                return indirection == 0 ? 16 : 32;
            }
            if (stmt instanceof IASTSwitchStatement ? node.getPropertyInParent() == IASTSwitchStatement.CONTROLLER_EXP : stmt instanceof IASTWhileStatement && node.getPropertyInParent() == IASTWhileStatement.CONDITIONEXPRESSION) {
                return 16;
            }
        }
        return 0;
    }

    protected int rwInUnaryExpression(IASTNode node, IASTUnaryExpression expr, int indirection) {
        switch (expr.getOperator()) {
            case 11: {
                return this.rwAnyNode(expr, indirection);
            }
            case 5: {
                return this.rwAnyNode(expr, indirection + 1);
            }
            case 4: {
                if (indirection > 0) {
                    return this.rwAnyNode(expr, indirection - 1);
                }
                return 16;
            }
            case 0: 
            case 1: 
            case 9: 
            case 10: {
                return 48;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return 16;
            }
            case 8: 
            case 14: 
            case 15: {
                return 0;
            }
        }
        return 16;
    }

    protected int rwInBinaryExpression(IASTNode node, IASTBinaryExpression expr, int indirection) {
        switch (expr.getOperator()) {
            case 17: {
                if (node.getPropertyInParent() == IASTBinaryExpression.OPERAND_ONE) {
                    return 32;
                }
                return this.rwAssignmentToType(expr.getOperand1().getExpressionType(), indirection);
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (node.getPropertyInParent() == IASTBinaryExpression.OPERAND_ONE) {
                    return 48;
                }
                return 16;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 28: 
            case 29: {
                return 16;
            }
            case 4: 
            case 5: {
                if (indirection > 0) {
                    return this.rwAnyNode(expr, indirection);
                }
                return 16;
            }
        }
        return 16;
    }
}

