/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.Arrays;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMNamedNode
extends PDOMNode {
    private static final int NAME = 8;
    protected static final int RECORD_SIZE = 12;
    private char[] fName;

    public PDOMNamedNode(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMNamedNode(PDOM pdom, PDOMNode parent, char[] name) throws CoreException {
        super(pdom, parent);
        this.fName = name;
        Database db = pdom.getDB();
        db.putInt(this.record + 8, name != null ? db.newString(name).getRecord() : 0);
    }

    protected abstract int getRecordSize();

    public IString getDBName() throws CoreException {
        Database db = this.pdom.getDB();
        int namerec = db.getInt(this.record + 8);
        return db.getString(namerec);
    }

    public static IString getDBName(PDOM pdom, int record) throws CoreException {
        Database db = pdom.getDB();
        int namerec = db.getInt(record + 8);
        return db.getString(namerec);
    }

    public char[] getNameCharArray() throws CoreException {
        if (this.fName != null) {
            return this.fName;
        }
        this.fName = this.getDBName().getChars();
        return this.fName;
    }

    public boolean hasName(char[] name) throws CoreException {
        if (this.fName != null) {
            return Arrays.equals(this.fName, name);
        }
        return this.getDBName().equals(name);
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        Database db = this.pdom.getDB();
        int namerec = db.getInt(this.record + 8);
        if (namerec != 0) {
            db.free(namerec);
        }
        super.delete(linkage);
    }

    public boolean mayHaveChildren() {
        return false;
    }
}

