/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;

public class TypeInfo
implements ITypeInfo {
    protected int fElementType;
    protected IQualifiedTypeName fQualifiedName;
    protected ITypeReference[] fSourceRefs = null;
    protected int fSourceRefsCount = 0;
    protected ITypeReference[] fDerivedSourceRefs = null;
    protected int fDerivedSourceRefsCount = 0;
    protected static final int INITIAL_REFS_SIZE = 1;
    protected static final int REFS_GROW_BY = 2;
    protected static final ITypeInfo[] EMPTY_TYPES = new ITypeInfo[0];

    public TypeInfo(int elementType, IQualifiedTypeName typeName) {
        this.fElementType = elementType;
        this.fQualifiedName = typeName;
    }

    public void addReference(ITypeReference location) {
        if (this.fSourceRefs == null) {
            this.fSourceRefs = new ITypeReference[1];
            this.fSourceRefsCount = 0;
        } else if (this.fSourceRefsCount == this.fSourceRefs.length) {
            ITypeReference[] refs = new ITypeReference[this.fSourceRefs.length + 2];
            System.arraycopy(this.fSourceRefs, 0, refs, 0, this.fSourceRefsCount);
            this.fSourceRefs = refs;
        }
        this.fSourceRefs[this.fSourceRefsCount] = location;
        ++this.fSourceRefsCount;
    }

    public ITypeReference[] getReferences() {
        if (this.fSourceRefs != null) {
            ITypeReference[] refs = new ITypeReference[this.fSourceRefsCount];
            System.arraycopy(this.fSourceRefs, 0, refs, 0, this.fSourceRefsCount);
            return refs;
        }
        return null;
    }

    public ITypeReference getResolvedReference() {
        int i = 0;
        while (i < this.fSourceRefsCount) {
            ITypeReference location = this.fSourceRefs[i];
            if (location.isLineNumber()) {
                return location;
            }
            if (location.getLength() != 0) {
                return location;
            }
            ++i;
        }
        return null;
    }

    public boolean isReferenced() {
        return this.fSourceRefs != null || this.fDerivedSourceRefs != null;
    }

    public boolean isReferenced(ITypeSearchScope scope) {
        ITypeReference location;
        if (scope == null || scope.isWorkspaceScope()) {
            return true;
        }
        int i = 0;
        while (i < this.fSourceRefsCount) {
            location = this.fSourceRefs[i];
            if (scope.encloses(location.getPath())) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.fDerivedSourceRefsCount) {
            location = this.fDerivedSourceRefs[i];
            if (scope.encloses(location.getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isUndefinedType() {
        return this.fElementType == 0;
    }

    public boolean canSubstituteFor(ITypeInfo info) {
        return this.isExactMatch(info);
    }

    protected boolean isExactMatch(ITypeInfo info) {
        if (this.hashCode() != info.hashCode()) {
            return false;
        }
        if (this.fElementType == info.getCElementType() && this.fQualifiedName.equals(info.getQualifiedTypeName())) {
            ICProject project1 = this.getEnclosingProject();
            ICProject project2 = info.getEnclosingProject();
            if (project1 == null && project2 == null) {
                return true;
            }
            if (project1 == null || project2 == null) {
                return false;
            }
            return project1.equals(project2);
        }
        return false;
    }

    public boolean exists() {
        return true;
    }

    public int getCElementType() {
        return this.fElementType;
    }

    public void setCElementType(int type) {
        this.fElementType = type;
    }

    public IQualifiedTypeName getQualifiedTypeName() {
        return this.fQualifiedName;
    }

    public String getName() {
        return this.fQualifiedName.getName();
    }

    public boolean isEnclosedType() {
        return this.fQualifiedName.isQualified();
    }

    public ITypeInfo getEnclosingType(int[] kinds) {
        return null;
    }

    public ITypeInfo getEnclosingType() {
        return this.getEnclosingType(KNOWN_TYPES);
    }

    public ITypeInfo getEnclosingNamespace(boolean includeGlobalNamespace) {
        return null;
    }

    public ITypeInfo getRootNamespace(boolean includeGlobalNamespace) {
        return null;
    }

    public boolean isEnclosingType() {
        return this.fElementType == 61 || this.fElementType == 65 || this.fElementType == 67;
    }

    public boolean encloses(ITypeInfo info) {
        return false;
    }

    public boolean isEnclosed(ITypeInfo info) {
        return info.encloses(this);
    }

    public boolean hasEnclosedTypes() {
        return false;
    }

    public ITypeInfo[] getEnclosedTypes() {
        return this.getEnclosedTypes(KNOWN_TYPES);
    }

    public ITypeInfo[] getEnclosedTypes(int[] kinds) {
        return EMPTY_TYPES;
    }

    public ICProject getEnclosingProject() {
        return null;
    }

    public String toString() {
        return this.fQualifiedName.toString();
    }

    public boolean isEnclosed(ITypeSearchScope scope) {
        if (scope == null || scope.isWorkspaceScope()) {
            return true;
        }
        int i = 0;
        while (i < this.fSourceRefsCount) {
            ITypeReference location = this.fSourceRefs[i];
            if (scope.encloses(location.getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.fQualifiedName.hashCode() + this.fElementType;
        ICProject project = this.getEnclosingProject();
        if (project != null) {
            hashCode += project.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypeInfo)) {
            return false;
        }
        return this.isExactMatch((TypeInfo)obj);
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof TypeInfo)) {
            throw new ClassCastException();
        }
        TypeInfo info = (TypeInfo)obj;
        if (this.fElementType != info.fElementType) {
            return this.fElementType < info.fElementType ? -1 : 1;
        }
        return this.fQualifiedName.compareTo(info.getQualifiedTypeName());
    }

    public static boolean isValidType(int type) {
        int i = 0;
        while (i < KNOWN_TYPES.length) {
            if (KNOWN_TYPES[i] == type) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addDerivedReference(ITypeReference location) {
        if (this.fDerivedSourceRefs == null) {
            this.fDerivedSourceRefs = new ITypeReference[1];
            this.fDerivedSourceRefsCount = 0;
        } else if (this.fDerivedSourceRefsCount == this.fDerivedSourceRefs.length) {
            ITypeReference[] refs = new ITypeReference[this.fDerivedSourceRefs.length + 2];
            System.arraycopy(this.fDerivedSourceRefs, 0, refs, 0, this.fDerivedSourceRefsCount);
            this.fDerivedSourceRefs = refs;
        }
        this.fDerivedSourceRefs[this.fDerivedSourceRefsCount] = location;
        ++this.fDerivedSourceRefsCount;
    }

    public ITypeReference[] getDerivedReferences() {
        if (this.fDerivedSourceRefs != null) {
            ITypeReference[] refs = new ITypeReference[this.fDerivedSourceRefsCount];
            System.arraycopy(this.fDerivedSourceRefs, 0, refs, 0, this.fDerivedSourceRefsCount);
            return refs;
        }
        return null;
    }

    public boolean hasSubTypes() {
        return this.fDerivedSourceRefs != null;
    }

    public ITypeInfo[] getSubTypes() {
        return null;
    }

    public boolean hasSuperTypes() {
        return false;
    }

    public ITypeInfo[] getSuperTypes() {
        return null;
    }

    public ASTAccessVisibility getSuperTypeAccess(ITypeInfo superType) {
        return null;
    }

    public boolean isClass() {
        return this.fElementType == 65 || this.fElementType == 67;
    }
}

