/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.tau.papitest.actions;

import java.io.File;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ptp.perf.tau.papiselect.PapiListSelectionDialog;
import org.eclipse.ptp.perf.tau.papiselect.papic.EventTreeDialog;
import org.eclipse.ptp.perf.tau.papitest.Activator;
import org.eclipse.ptp.perf.tau.papitest.actions.PAPISplash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class TestPAPI
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    protected static final String papiLocationSelectionVar = "ID.of.PAPI.bin.directory.location";
    protected static final String papiCounterTypeVar = "ID.of.PAPI.counter.type.selected";

    public void run(IAction action) {
        LabelProvider papilab = new LabelProvider();
        ArrayContentProvider paprov = new ArrayContentProvider();
        PAPISplash splash = new PAPISplash(this.window.getShell());
        splash.open();
        int papiCountType = Activator.getDefault().getPreferenceStore().getInt(papiCounterTypeVar);
        String papiLoc = Activator.getDefault().getPreferenceStore().getString(papiLocationSelectionVar);
        File pdir = new File(papiLoc);
        if (!pdir.isDirectory() || !pdir.canRead()) {
            return;
        }
        File pcxi = new File(String.valueOf(papiLoc) + File.separator + "papi_xml_event_info");
        if (pcxi.canRead() && pcxi.exists()) {
            EventTreeDialog treeD = new EventTreeDialog(this.window.getShell(), papiLoc);
            if (treeD.open() == 0) {
                this.showCounters(treeD.getCommands().toArray());
            }
            return;
        }
        PapiListSelectionDialog papidialog = new PapiListSelectionDialog(this.window.getShell(), papiLoc, (IStructuredContentProvider)paprov, (ILabelProvider)papilab, "Select PAPI counters", papiCountType);
        papidialog.setTitle("PAPI Counters");
        papidialog.setHelpAvailable(false);
        if (papidialog.open() == 0) {
            Object[] selected = papidialog.getResult();
            this.showCounters(selected);
        }
    }

    private void showCounters(Object[] selected) {
        if (selected != null && selected.length > 0) {
            String counters = "";
            int i = 0;
            while (i < selected.length) {
                counters = String.valueOf(counters) + selected[i] + "\n";
                ++i;
            }
            MessageDialog.openInformation((Shell)this.window.getShell(), (String)"Selected PAPI Counters:", (String)counters);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

