/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.managedbuilder.core;

import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedOptionValueHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ptp.cell.managedbuilder.debug.Debug;

public abstract class CellDefaultOptionValueHandler
extends ManagedOptionValueHandler {
    protected IOption setValue(IBuildObject configuration, IHoldsOptions holder, IOption option, boolean value) throws BuildException {
        IOption returnOption;
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_HANDLER, new Object[]{configuration.getId(), holder.getId(), option.getId(), value});
        Assert.isLegal((option.getBasicValueType() == 0 ? 1 : 0) != 0, (String)(String.valueOf(option.getId()) + " is not a valid IOption.BOOLEAN option"));
        if (configuration instanceof IConfiguration) {
            Debug.POLICY.enter(Debug.DEBUG_HANDLER, new Object[]{"IConfiguration"});
            returnOption = ((IConfiguration)configuration).setOption(holder, option, value);
        } else if (configuration instanceof IResourceInfo) {
            Debug.POLICY.enter(Debug.DEBUG_HANDLER, new Object[]{"IResourceInfo"});
            returnOption = ((IResourceInfo)configuration).setOption(holder, option, value);
        } else {
            Debug.POLICY.error(Debug.DEBUG_HANDLER, "neither IConfiguration nor IResourceInfo");
            returnOption = null;
        }
        Debug.POLICY.exit(Debug.DEBUG_HANDLER);
        return returnOption;
    }

    protected IOption setValue(IBuildObject configuration, IHoldsOptions holder, IOption option, String[] value) throws BuildException {
        IOption returnOption;
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_HANDLER, new Object[]{configuration.getId(), holder.getId(), option.getId(), value});
        Assert.isLegal((option.getBasicValueType() == 3 ? 1 : 0) != 0, (String)(String.valueOf(option.getId()) + " is not a valid IOption.STRING_LIST option"));
        if (configuration instanceof IConfiguration) {
            Debug.POLICY.enter(Debug.DEBUG_HANDLER, new Object[]{"IConfiguration"});
            returnOption = ((IConfiguration)configuration).setOption(holder, option, value);
        } else if (configuration instanceof IResourceInfo) {
            Debug.POLICY.enter(Debug.DEBUG_HANDLER, new Object[]{"IResourceInfo"});
            returnOption = ((IResourceInfo)configuration).setOption(holder, option, value);
        } else {
            returnOption = null;
            Debug.POLICY.error(Debug.DEBUG_HANDLER, "neither IConfiguration nor IResourceInfo");
        }
        Debug.POLICY.exit(Debug.DEBUG_HANDLER);
        return returnOption;
    }

    protected IOption setValue(IBuildObject configuration, IHoldsOptions holder, IOption option, String[] previousValues, String specificValue, boolean include) throws BuildException {
        int i;
        String[] newValues;
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_HANDLER, new Object[]{configuration.getId(), holder.getId(), option.getId(), previousValues, specificValue, include});
        Assert.isLegal((option.getBasicValueType() == 3 ? 1 : 0) != 0, (String)(String.valueOf(option.getId()) + " is not a valid IOption.STRING_LIST option"));
        int specificValueCounter = 0;
        int i2 = 0;
        while (i2 < previousValues.length) {
            if (previousValues[i2].equals(specificValue)) {
                ++specificValueCounter;
            }
            ++i2;
        }
        if (include) {
            if (specificValueCounter == 0) {
                newValues = new String[previousValues.length + 1];
                newValues[0] = specificValue;
                i = 0;
                int j = 1;
                while (i < previousValues.length) {
                    newValues[j] = previousValues[i];
                    ++i;
                    ++j;
                }
                Debug.POLICY.trace(Debug.DEBUG_HANDLER, "Included specific value {0} in list.", new Object[]{specificValue});
            } else {
                newValues = previousValues;
                Debug.POLICY.trace(Debug.DEBUG_HANDLER, "Specific value {0} is already in list.", new Object[]{specificValue});
            }
        } else {
            newValues = new String[previousValues.length - specificValueCounter];
            i = 0;
            int j = 0;
            while (i < previousValues.length) {
                if (!previousValues[i].equals(specificValue)) {
                    newValues[j] = previousValues[i];
                    ++j;
                } else {
                    Debug.POLICY.trace(Debug.DEBUG_HANDLER, "Removed specific value {0} from list.", new Object[]{specificValue});
                }
                ++i;
            }
        }
        IOption returnOption = this.setValue(configuration, holder, option, newValues);
        Debug.POLICY.exit(Debug.DEBUG_HANDLER);
        return returnOption;
    }

    protected boolean isValueInStringList(String[] stringList, String value) {
        boolean found = false;
        int i = 0;
        while (i < stringList.length && !found) {
            if (stringList[i].equals(value)) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    protected boolean areValuesInStringList(String[] stringList, String ... values) {
        boolean found = true;
        int i = 0;
        while (i < values.length && found) {
            if (!this.isValueInStringList(stringList, values[i])) {
                found = false;
            }
            ++i;
        }
        return found;
    }
}

