/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rmsystem;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.rm.core.rmsystem.AbstractToolRMConfiguration;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2PreferenceManager;
import org.eclipse.ptp.rm.mpi.mpich2.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.mpich2.core.rmsystem.MPICH2ResourceManagerFactory;
import org.eclipse.ptp.rm.remote.core.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ui.IMemento;

public class MPICH2ResourceManagerConfiguration
extends AbstractToolRMConfiguration
implements Cloneable {
    public static int MPICH2_CAPABILITIES = 23;
    private static final String TAG_VERSION_ID = "versionId";
    private String versionId;

    public static MPICH2Config loadOpenMpiConfig(IResourceManagerFactory factory, IMemento memento) {
        AbstractToolRMConfiguration.ToolsConfig toolsConfig = MPICH2ResourceManagerConfiguration.loadTool((IResourceManagerFactory)factory, (IMemento)memento);
        String versionId = memento.getString(TAG_VERSION_ID);
        MPICH2Config config = new MPICH2Config(toolsConfig, versionId);
        return config;
    }

    public static MPICH2ResourceManagerConfiguration load(MPICH2ResourceManagerFactory factory, IMemento memento) {
        MPICH2Config mpich2Config = MPICH2ResourceManagerConfiguration.loadOpenMpiConfig((IResourceManagerFactory)factory, memento);
        MPICH2ResourceManagerConfiguration config = new MPICH2ResourceManagerConfiguration(factory, mpich2Config);
        return config;
    }

    public MPICH2ResourceManagerConfiguration(MPICH2ResourceManagerFactory factory) {
        super(MPICH2_CAPABILITIES, new AbstractToolRMConfiguration.ToolsConfig(), (IResourceManagerFactory)factory);
        Preferences prefs = MPICH2PreferenceManager.getPreferences();
        this.setLaunchCmd(prefs.getString("mpich2-launchCmd"));
        this.setDebugCmd(prefs.getString("mpich2-debugCmd"));
        this.setDiscoverCmd(prefs.getString("mpich2-discoverCmd"));
        this.setPeriodicMonitorCmd(prefs.getString("mpich2-periodicMonitorCmd"));
        this.setPeriodicMonitorTime(prefs.getInt("mpich2-periodicMonitorTime"));
        this.setRemoteInstallPath(prefs.getString("mpich2-remoteInstallPAth"));
    }

    public MPICH2ResourceManagerConfiguration(MPICH2ResourceManagerFactory factory, MPICH2Config config) {
        super(MPICH2_CAPABILITIES, config.getToolsConfig(), (IResourceManagerFactory)factory);
    }

    public Object clone() {
        AbstractResourceManagerConfiguration.CommonConfig commonConf = new AbstractResourceManagerConfiguration.CommonConfig(this.getName(), this.getDescription(), this.getUniqueName());
        AbstractRemoteResourceManagerConfiguration.RemoteConfig remoteConf = new AbstractRemoteResourceManagerConfiguration.RemoteConfig(commonConf, this.getRemoteServicesId(), this.getConnectionName(), this.getProxyServerPath(), this.getLocalAddress(), this.getInvocationOptionsStr(), this.getOptions());
        AbstractToolRMConfiguration.ToolsConfig toolsConfig = new AbstractToolRMConfiguration.ToolsConfig(remoteConf, this.getLaunchCmd(), this.getDebugCmd(), this.getDiscoverCmd(), this.getPeriodicMonitorCmd(), this.getPeriodicMonitorTime(), this.getContinuousMonitorCmd(), this.getRemoteInstallPath(), this.useToolDefaults());
        MPICH2Config openMpiConfig = new MPICH2Config(toolsConfig, this.getVersionId());
        return new MPICH2ResourceManagerConfiguration((MPICH2ResourceManagerFactory)this.getFactory(), openMpiConfig);
    }

    public void save(IMemento memento) {
        super.save(memento);
        memento.putString(TAG_VERSION_ID, this.versionId);
    }

    public void setDefaultNameAndDesc() {
        String name = Messages.MPICH2ResourceManagerConfiguration_defaultName;
        String conn = this.getConnectionName();
        if (conn != null && !conn.equals("")) {
            name = String.valueOf(name) + "@" + conn;
        }
        this.setName(name);
        this.setDescription(Messages.MPICH2ResourceManagerConfiguration_defaultDescription);
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public static class MPICH2Config {
        private AbstractToolRMConfiguration.ToolsConfig toolsConfig;
        private String versionId;

        public MPICH2Config() {
            this(new AbstractToolRMConfiguration.ToolsConfig(), null);
        }

        public MPICH2Config(AbstractToolRMConfiguration.ToolsConfig toolsConfig, String versionId) {
            this.toolsConfig = toolsConfig;
            this.versionId = versionId;
        }

        public AbstractToolRMConfiguration.ToolsConfig getToolsConfig() {
            return this.toolsConfig;
        }

        public void setToolsConfig(AbstractToolRMConfiguration.ToolsConfig toolsConfig) {
            this.toolsConfig = toolsConfig;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public void setVersionId(String versionId) {
            this.versionId = versionId;
        }
    }
}

