/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.ChannelExec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.ptp.remotetools.core.IRemoteScriptExecution;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.internal.common.Debug;
import org.eclipse.ptp.remotetools.internal.common.RemoteScript;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.KillableExecution;
import org.eclipse.ptp.remotetools.internal.ssh.Messages;

public class ScriptExecution
extends KillableExecution
implements IRemoteScriptExecution {
    protected RemoteScript remoteScript;
    protected InputStream fromProcessOutput;
    protected InputStream fromProcessError;
    protected OutputStream toProcessInput;

    protected ScriptExecution(ExecutionManager executionManager, RemoteScript remoteScript) throws RemoteConnectionException {
        super(executionManager);
        this.remoteScript = remoteScript;
    }

    public void startExecution() throws RemoteConnectionException {
        String commandline = this.getRemoteScript().getScriptString();
        ChannelExec channel = this.createChannel(this.getRemoteScript().getAllocateTerminal());
        this.setCommandLine(commandline);
        try {
            if (this.remoteScript.getInputStream() != null) {
                channel.setInputStream(this.remoteScript.getInputStream());
            } else if (this.remoteScript.getFetchProcessInputStream()) {
                this.toProcessInput = channel.getOutputStream();
            }
            if (this.remoteScript.getOutputStream() != null) {
                channel.setOutputStream(this.remoteScript.getOutputStream());
            } else if (this.remoteScript.getFetchProcessOutputStream()) {
                this.fromProcessOutput = channel.getInputStream();
            }
            if (this.remoteScript.getErrorStream() != null) {
                channel.setErrStream(this.remoteScript.getErrorStream());
            } else if (this.remoteScript.getFetchProcessErrorStream()) {
                this.fromProcessError = channel.getErrStream();
            }
        }
        catch (IOException e) {
            throw new RemoteConnectionException(Messages.ScriptExecution_StartExecution_FailedInitStreams, e);
        }
        channel.setXForwarding(this.remoteScript.willForwardX11());
        super.startExecution();
        Debug.println("Executing " + commandline);
    }

    public InputStream getInputStreamFromProcessOutputStream() throws IOException {
        if (this.fromProcessOutput == null) {
            throw new IllegalStateException();
        }
        return this.fromProcessOutput;
    }

    public InputStream getInputStreamFromProcessErrorStream() throws IOException {
        if (this.fromProcessError == null) {
            throw new IllegalStateException();
        }
        return this.fromProcessError;
    }

    public OutputStream getOutputStreamToProcessInputStream() throws IOException {
        if (this.toProcessInput == null) {
            throw new IllegalStateException();
        }
        return this.toProcessInput;
    }

    public RemoteScript getRemoteScript() {
        return this.remoteScript;
    }
}

