/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.alf.ui.core;

public class ALFBuffer {
    private String variable_name;
    private String element_type;
    private int element_unit;
    private int buffer_type;
    private int num_dimensions;
    private long dimension_size_x;
    private long dimension_size_y;
    private long dimension_size_z;
    private int distribution_model_x;
    private int distribution_model_y;
    private int distribution_model_z;
    private long distribution_size_x;
    private long distribution_size_y;
    private long distribution_size_z;
    private long numDTEntries;
    private boolean isValid;

    public ALFBuffer() {
        this.variable_name = null;
        this.element_type = null;
        this.element_unit = -1;
        this.buffer_type = -1;
        this.num_dimensions = -1;
        this.dimension_size_x = -1L;
        this.dimension_size_y = -1L;
        this.dimension_size_z = -1L;
        this.distribution_model_x = -1;
        this.distribution_model_y = -1;
        this.distribution_model_z = -1;
        this.distribution_size_x = -1L;
        this.distribution_size_y = -1L;
        this.distribution_size_z = -1L;
        this.numDTEntries = -1L;
        this.isValid = false;
    }

    public ALFBuffer(String name, String type, int unit, int buffer, int num_dim, long dim_size_x, long dim_size_y, long dim_size_z, int dist_model_x, int dist_model_y, int dist_model_z, long dist_size_x, long dist_size_y, long dist_size_z, boolean isValid) {
        this.variable_name = name;
        this.element_type = type;
        this.element_unit = unit;
        this.buffer_type = buffer;
        this.num_dimensions = num_dim;
        this.dimension_size_x = dim_size_x;
        this.dimension_size_y = dim_size_y;
        this.dimension_size_z = dim_size_z;
        this.distribution_model_x = dist_model_x;
        this.distribution_model_y = dist_model_y;
        this.distribution_model_z = dist_model_z;
        this.distribution_size_x = dist_size_x;
        this.distribution_size_y = dist_size_y;
        this.distribution_size_z = dist_size_z;
        this.isValid = isValid;
        switch (this.num_dimensions) {
            case 0: {
                this.numDTEntries = dim_size_x / dist_size_x;
                break;
            }
            case 1: {
                this.numDTEntries = dim_size_x / dist_size_x * (dim_size_y / dist_size_y);
                break;
            }
            case 2: {
                this.numDTEntries = dim_size_x / dist_size_x * (dim_size_y / dist_size_y) * (dim_size_z / dist_size_z);
                break;
            }
            default: {
                throw new IllegalArgumentException("A runtime error has occured while trying to create the ALFBuffer object. The value of num_dimensions is invalid.");
            }
        }
    }

    public String getName() {
        return this.variable_name;
    }

    public void setName(String newName) {
        this.variable_name = newName;
    }

    public String getElementType() {
        return this.element_type;
    }

    public void setElementType(String newType) {
        this.element_type = newType;
    }

    public int getElementUnit() {
        return this.element_unit;
    }

    public void setElementUnit(int newUnit) {
        this.element_unit = newUnit;
    }

    public int getBufferType() {
        return this.buffer_type;
    }

    public void setBufferType(int newBufferType) {
        this.buffer_type = newBufferType;
    }

    public int getNumDimensions() {
        return this.num_dimensions;
    }

    public void setNumDimensions(int newNumDimensions) {
        this.num_dimensions = newNumDimensions;
    }

    public long getDimensionSizeX() {
        return this.dimension_size_x;
    }

    public void setDimensionSizeX(long newDimensionSizeX) {
        this.dimension_size_x = newDimensionSizeX;
    }

    public long getDimensionSizeY() {
        return this.dimension_size_y;
    }

    public void setDimensionSizeY(long newDimensionSizeY) {
        this.dimension_size_y = newDimensionSizeY;
    }

    public long getDimensionSizeZ() {
        return this.dimension_size_z;
    }

    public void setDimensionSizeZ(long newDimensionSizeZ) {
        this.dimension_size_z = newDimensionSizeZ;
    }

    public int getDistributionModelX() {
        return this.distribution_model_x;
    }

    public void setDistributionModelX(int newDistributionModelX) {
        this.distribution_model_x = newDistributionModelX;
    }

    public int getDistributionModelY() {
        return this.distribution_model_y;
    }

    public void setDistributionModelY(int newDistributionModelY) {
        this.distribution_model_y = newDistributionModelY;
    }

    public int getDistributionModelZ() {
        return this.distribution_model_z;
    }

    public void setDistributionModelZ(int newDistributionModelZ) {
        this.distribution_model_z = newDistributionModelZ;
    }

    public long getDistributionSizeX() {
        return this.distribution_size_x;
    }

    public void setDistributionSizeX(long newDistributionSizeX) {
        this.distribution_size_x = newDistributionSizeX;
    }

    public long getDistributionSizeY() {
        return this.distribution_size_y;
    }

    public void setDistributionSizeY(long newDistributionSizeY) {
        this.distribution_size_y = newDistributionSizeY;
    }

    public long getDistributionSizeZ() {
        return this.distribution_size_z;
    }

    public void setDistributionSizeZ(long newDistributionSizeZ) {
        this.distribution_size_z = newDistributionSizeZ;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setIsValid(boolean newIsValid) {
        this.isValid = newIsValid;
    }

    public long getNumberDTEntries() {
        this.updateNumDTEntries();
        return this.numDTEntries;
    }

    public void updateNumDTEntries() {
        switch (this.num_dimensions) {
            case 0: {
                this.numDTEntries = this.dimension_size_x / this.distribution_size_x;
                break;
            }
            case 1: {
                this.numDTEntries = this.dimension_size_x / this.distribution_size_x * (this.dimension_size_y / this.distribution_size_y);
                break;
            }
            case 2: {
                this.numDTEntries = this.dimension_size_x / this.distribution_size_x * (this.dimension_size_y / this.distribution_size_y) * (this.dimension_size_z / this.distribution_size_z);
                break;
            }
            default: {
                throw new IllegalArgumentException("A runtime error has occured while trying to create the ALFBuffer object. The value of num_dimensions is invalid.");
            }
        }
    }
}

