/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.ui.deploy.events;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.cell.environment.ui.deploy.debug.Debug;
import org.eclipse.ptp.cell.environment.ui.deploy.events.AbstractCellTargetJob;
import org.eclipse.ptp.cell.environment.ui.deploy.events.Messages;
import org.eclipse.ptp.cell.environment.ui.deploy.wizard.CellImportResourcesPage;
import org.eclipse.ptp.remotetools.core.IRemoteCopyTools;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.ITargetJob;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;

public class ImportJobWrapper
implements IRunnableWithProgress {
    private ITargetControl cellControl;
    private String[][] resources;
    private String localDir;
    private CellImportResourcesPage importPage;
    private boolean copyEntireDir = false;

    public void init(ITargetControl control, String[][] resourcesToImport, String dir, CellImportResourcesPage page) {
        Debug.POLICY.pass(Debug.DEBUG_JOBS, control.toString(), new Object[]{resourcesToImport.length, dir, page.getName()});
        this.cellControl = control;
        this.resources = resourcesToImport;
        this.localDir = dir;
        this.importPage = page;
    }

    public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Debug.POLICY.enter(Debug.DEBUG_JOBS);
        monitor.beginTask(Messages.ImportJobWrapper_0, this.resources.length);
        if (monitor.isCanceled()) {
            throw new InterruptedException(Messages.ImportJobWrapper_1);
        }
        AbstractCellTargetJob importJob = new AbstractCellTargetJob(){

            public void run() {
                Debug.POLICY.enter(Debug.DEBUG_JOBS);
                try {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException(Messages.ImportJobWrapper_2);
                    }
                    IRemoteFileTools fileTools = this.executionManager.getRemoteFileTools();
                    monitor.setTaskName(Messages.ImportJobWrapper_3);
                    String localPath = ImportJobWrapper.this.localDir;
                    int i = 0;
                    while (i < ImportJobWrapper.this.resources.length) {
                        block14: {
                            block13: {
                                IRemoteCopyTools copyTools;
                                String[] currentItem;
                                block12: {
                                    String temp;
                                    if (monitor.isCanceled()) {
                                        throw new InterruptedException(Messages.ImportJobWrapper_4);
                                    }
                                    currentItem = ImportJobWrapper.this.resources[i];
                                    localPath = ImportJobWrapper.this.localDir;
                                    copyTools = fileTools.getRemoteCopyTools();
                                    if (!currentItem[1].equals("Directory")) break block12;
                                    Debug.POLICY.pass(Debug.DEBUG_JOBS, "Directory: {0}", new Object[]{currentItem[0].toString()});
                                    monitor.subTask(String.valueOf(Messages.ImportJobWrapper_5) + currentItem[0]);
                                    if (ImportJobWrapper.this.copyEntireDir && (temp = ImportJobWrapper.this.getDirectoryName(currentItem[0])) != null) {
                                        localPath = String.valueOf(ImportJobWrapper.this.localDir) + '/' + temp;
                                    }
                                    copyTools.downloadDirToDir(currentItem[0], localPath, true);
                                    break block13;
                                }
                                if (!currentItem[1].equals("File")) break block14;
                                Debug.POLICY.pass(Debug.DEBUG_JOBS, "File: {0}", new Object[]{currentItem[0].toString()});
                                monitor.subTask(String.valueOf(Messages.ImportJobWrapper_6) + currentItem[0]);
                                copyTools.downloadFileToDir(currentItem[0], ImportJobWrapper.this.localDir);
                            }
                            monitor.worked(1);
                        }
                        ++i;
                    }
                }
                catch (RemoteConnectionException e) {
                    Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
                    this.exception = e;
                    this.errorMessage = Messages.ImportJobWrapper_7;
                    this.hadError = true;
                }
                catch (RemoteOperationException e) {
                    Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
                    this.exception = e;
                    this.errorMessage = Messages.ImportJobWrapper_8;
                    this.hadError = true;
                }
                catch (CancelException e) {
                    Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
                    this.exception = e;
                    this.errorMessage = Messages.ImportJobWrapper_9;
                    this.hadError = true;
                }
                catch (InterruptedException e) {
                    Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
                    this.exception = e;
                    this.hadError = true;
                }
                Debug.POLICY.enter(Debug.DEBUG_JOBS);
            }
        };
        try {
            try {
                this.cellControl.startJob((ITargetJob)importJob);
                importJob.waitFor(monitor, Messages.ImportJobWrapper_10);
                if (importJob.didHaveError()) {
                    Exception exception = importJob.getException();
                    if (exception instanceof InterruptedException) {
                        throw (InterruptedException)exception;
                    }
                    if (exception instanceof InvocationTargetException) {
                        throw (InvocationTargetException)exception;
                    }
                    throw new InvocationTargetException(importJob.getException(), importJob.getErrorMessage());
                }
            }
            catch (CoreException e) {
                Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
                throw new InvocationTargetException(e, Messages.ImportJobWrapper_11);
            }
        }
        finally {
            monitor.done();
        }
        Debug.POLICY.enter(Debug.DEBUG_JOBS);
    }

    private String getDirectoryName(String path) {
        int i = path.length() - 1;
        while (i >= 0) {
            if (path.charAt(i) == '/') {
                return path.substring(i + 1, path.length());
            }
            --i;
        }
        return null;
    }

    public void setCopyEntireDir(boolean val) {
        Debug.POLICY.pass(Debug.DEBUG_JOBS, new Object[]{val});
        this.copyEntireDir = val;
    }
}

