/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.ui.deploy.wizard;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.cell.environment.ui.deploy.DeployPlugin;
import org.eclipse.ptp.cell.environment.ui.deploy.debug.Debug;
import org.eclipse.ptp.cell.environment.ui.deploy.events.AbstractCellTargetJob;
import org.eclipse.ptp.cell.environment.ui.deploy.events.ImportJobWrapper;
import org.eclipse.ptp.cell.environment.ui.deploy.events.Messages;
import org.eclipse.ptp.cell.environment.ui.deploy.wizard.AbstractCellWizardPage;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.ITargetJob;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class CellImportResourcesPage
extends AbstractCellWizardPage {
    private Table resourceTable;
    private Button addFileButton;
    private Button addDirButton;
    private Button removeSelectedButton;
    private Text destinationNameField;
    private Button destinationBrowseButton;
    private Button createSelectedDir;
    private Button copyDirContentsOnly;
    private boolean sourceValid = true;

    public CellImportResourcesPage(String pageName, ITargetControl control) {
        super(pageName, control);
        this.setTitle(Messages.CellImportResourcesPage_3);
        this.setDescription(Messages.CellImportResourcesPage_4);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.destinationNameField.setFocus();
    }

    protected void createAdditionalFilesGroup(Composite parent) {
        Font font = parent.getFont();
        Group filesGroup = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 1;
        filesGroup.setLayout((Layout)groupLayout);
        filesGroup.setLayoutData((Object)new GridData(784));
        filesGroup.setText(Messages.CellImportResourcesPage_5);
        filesGroup.setFont(font);
        this.resourceTable = new Table((Composite)filesGroup, 2);
        GridData tableData = new GridData(768);
        tableData.widthHint = 550;
        tableData.heightHint = 75;
        this.resourceTable.setLayoutData((Object)tableData);
        this.resourceTable.setFont(font);
        this.resourceTable.setLinesVisible(false);
        this.resourceTable.setHeaderVisible(true);
        this.resourceTable.setEnabled(true);
        TableColumn column1 = new TableColumn(this.resourceTable, 16384, 0);
        TableColumn column2 = new TableColumn(this.resourceTable, 131072, 1);
        column1.setText(Messages.CellImportResourcesPage_6);
        column1.setWidth(500);
        column2.setText(Messages.CellImportResourcesPage_7);
        column2.setWidth(25);
        Composite comp = new Composite((Composite)filesGroup, 0);
        GridLayout compLayout = new GridLayout();
        compLayout.numColumns = 3;
        comp.setLayout((Layout)compLayout);
        comp.setLayoutData((Object)new GridData(48));
        this.addFileButton = new Button(comp, 8);
        this.addFileButton.setText(Messages.CellImportResourcesPage_8);
        this.addFileButton.addListener(13, (Listener)this);
        this.addFileButton.setFont(font);
        this.setButtonLayoutData(this.addFileButton);
        this.addDirButton = new Button(comp, 8);
        this.addDirButton.setText(Messages.CellImportResourcesPage_9);
        this.addDirButton.addListener(13, (Listener)this);
        this.addDirButton.setFont(font);
        this.setButtonLayoutData(this.addDirButton);
        this.removeSelectedButton = new Button(comp, 8);
        this.removeSelectedButton.setText(Messages.CellImportResourcesPage_10);
        this.removeSelectedButton.addListener(13, (Listener)this);
        this.removeSelectedButton.setFont(font);
        this.setButtonLayoutData(this.removeSelectedButton);
        new Label(parent, 0);
    }

    protected void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite destination = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destination.setLayout((Layout)layout);
        destination.setLayoutData((Object)new GridData(272));
        destination.setFont(font);
        Label destinationLabel = new Label(destination, 0);
        destinationLabel.setText(Messages.CellImportResourcesPage_11);
        destinationLabel.setFont(font);
        this.destinationNameField = new Text(destination, 18436);
        this.destinationNameField.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationNameField.setFont(font);
        this.destinationBrowseButton = new Button(destination, 8);
        this.destinationBrowseButton.setText(Messages.CellImportResourcesPage_12);
        this.destinationBrowseButton.addListener(13, (Listener)this);
        this.destinationBrowseButton.setFont(font);
        this.setButtonLayoutData(this.destinationBrowseButton);
        new Label(parent, 0);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        Font font = optionsGroup.getFont();
        this.createDirectoryStructureOptions((Composite)optionsGroup, font);
    }

    protected void createDirectoryStructureOptions(Composite optionsGroup, Font font) {
        this.createSelectedDir = new Button(optionsGroup, 16400);
        this.createSelectedDir.setText(Messages.CellImportResourcesPage_13);
        this.createSelectedDir.setFont(font);
        this.createSelectedDir.setSelection(true);
        this.copyDirContentsOnly = new Button(optionsGroup, 16400);
        this.copyDirContentsOnly.setText(Messages.CellImportResourcesPage_14);
        this.copyDirContentsOnly.setFont(font);
    }

    protected void createResourcesGroup(Composite parent) {
        this.createAdditionalFilesGroup(parent);
    }

    private boolean doesResourceTableContain(String name) {
        if (name == null || name.length() == 0) {
            return true;
        }
        TableItem[] items = this.resourceTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getText(0) != null && items[i].getText(0).equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean finish() {
        String[][] resources = this.getResources();
        String destination = this.getDestinationValue();
        if (resources.length < 1) {
            MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)Messages.CellImportResourcesPage_15, (String)Messages.CellImportResourcesPage_16);
            return false;
        }
        File destDir = new File(destination);
        if (!destDir.exists()) {
            boolean create = MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)Messages.CellImportResourcesPage_17, (String)Messages.CellImportResourcesPage_18);
            if (create) {
                destDir.mkdirs();
            } else {
                return false;
            }
        }
        if (destDir.exists() && destDir.isFile()) {
            boolean createDir = MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)Messages.CellImportResourcesPage_19, (String)Messages.CellImportResourcesPage_20);
            if (createDir) {
                destDir.delete();
                destDir.mkdirs();
            } else {
                return false;
            }
        }
        if (!destDir.canWrite()) {
            MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)Messages.CellImportResourcesPage_21, (String)Messages.CellImportResourcesPage_22);
            return false;
        }
        this.saveDirtyEditors();
        this.saveWidgetValues();
        try {
            ImportJobWrapper copyWrapper = new ImportJobWrapper();
            ProgressMonitorDialog jobMonitor = new ProgressMonitorDialog(this.getContainer().getShell());
            copyWrapper.init(this.cellControl, resources, destination, this);
            copyWrapper.setCopyEntireDir(this.createSelectedDir.getSelection());
            jobMonitor.setOpenOnRun(true);
            jobMonitor.run(true, true, (IRunnableWithProgress)copyWrapper);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() == null) {
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.CellImportResourcesPage_23, (String)e.getMessage());
                return false;
            }
            Debug.POLICY.logError((Throwable)e);
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)e.getMessage(), (String)e.getTargetException().toString());
            return false;
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)Messages.CellImportResourcesPage_24, (String)Messages.CellImportResourcesPage_25);
            return false;
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)Messages.CellImportResourcesPage_26, (String)Messages.CellImportResourcesPage_27);
        return true;
    }

    protected String getDestinationValue() {
        String path = this.destinationNameField.getText().trim();
        return this.removeTrailingSlashes(path);
    }

    private String[][] getResources() {
        TableItem[] items = this.resourceTable.getItems();
        String[][] resources = new String[items.length][2];
        int i = 0;
        while (i < items.length) {
            resources[i] = new String[]{items[i].getText(0), items[i].getText(1)};
            ++i;
        }
        return resources;
    }

    private void handleAddDirPressed() {
        InputDialog dialog = new InputDialog(this.getContainer().getShell(), Messages.CellImportResourcesPage_28, Messages.CellImportResourcesPage_29, Messages.CellImportResourcesPage_30, null);
        dialog.open();
        String path = dialog.getValue().trim();
        if (path != null && path.length() > 0) {
            String newPath = this.removeTrailingSlashes(path);
            if (this.validatePath(newPath, true) && !this.doesResourceTableContain(newPath)) {
                TableItem item = new TableItem(this.resourceTable, 16384);
                item.setText(0, newPath);
                item.setText(1, "Directory");
            }
        } else {
            this.setErrorMessage(Messages.CellImportResourcesPage_31);
            this.sourceValid = false;
        }
    }

    private void handleAddFilePressed() {
        InputDialog dialog = new InputDialog(this.getContainer().getShell(), Messages.CellImportResourcesPage_32, Messages.CellImportResourcesPage_33, Messages.CellImportResourcesPage_34, null);
        dialog.open();
        String path = dialog.getValue().trim();
        if (path != null && path.length() > 0) {
            if (this.validatePath(path, false) && !this.doesResourceTableContain(path)) {
                TableItem item = new TableItem(this.resourceTable, 16384);
                item.setText(0, path);
                item.setText(1, "File");
            }
        } else {
            this.setErrorMessage(Messages.CellImportResourcesPage_35);
            this.sourceValid = false;
        }
    }

    private void handleRemoveSelectedPressed() {
        int[] selected = this.resourceTable.getSelectionIndices();
        this.resourceTable.deselectAll();
        this.resourceTable.remove(selected);
    }

    protected void handleDestinationBrowseButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.getContainer().getShell(), 8192);
        dialog.setMessage(Messages.CellImportResourcesPage_36);
        dialog.setText(Messages.CellImportResourcesPage_37);
        dialog.setFilterPath(this.getDestinationValue());
        String selectedDirectoryName = dialog.open();
        if (selectedDirectoryName != null) {
            this.destinationNameField.setText(selectedDirectoryName);
        }
    }

    public void handleEvent(Event e) {
        try {
            Widget source = e.widget;
            if (source == this.destinationBrowseButton) {
                this.handleDestinationBrowseButtonPressed();
            } else if (source == this.addFileButton) {
                this.handleAddFilePressed();
            } else if (source == this.addDirButton) {
                this.handleAddDirPressed();
            } else if (source == this.removeSelectedButton) {
                this.handleRemoveSelectedPressed();
            }
            this.updatePageCompletion();
            if (this.sourceValid) {
                this.setErrorMessage(null);
            } else {
                this.sourceValid = true;
            }
        }
        catch (Exception ee) {
            Debug.POLICY.logError((Throwable)ee);
        }
    }

    protected boolean saveDirtyEditors() {
        return PlatformUI.getWorkbench().saveAllEditors(true);
    }

    protected boolean validateDestinationGroup() {
        String dest = this.getDestinationValue().trim();
        if (dest.length() == 0) {
            this.setMessage(Messages.CellImportResourcesPage_38);
            return false;
        }
        this.setMessage(null);
        return true;
    }

    protected boolean validateOptionsGroup() {
        return true;
    }

    protected boolean validatePath(String path, boolean isDir) {
        VerifyPathTargetJob verifyJob;
        block7: {
            verifyJob = new VerifyPathTargetJob(path, isDir);
            this.cellControl.startJob((ITargetJob)verifyJob);
            verifyJob.waitFor();
            if (!verifyJob.didHaveError()) break block7;
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)verifyJob.getErrorMessage(), (String)verifyJob.getException().toString());
            return false;
        }
        try {
            boolean exists = verifyJob.doesPathExist();
            if (!exists) {
                if (isDir) {
                    this.sourceValid = false;
                    this.setErrorMessage(Messages.CellImportResourcesPage_39);
                } else {
                    this.sourceValid = false;
                    this.setErrorMessage(Messages.CellImportResourcesPage_40);
                }
            }
            return exists;
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.CellImportResourcesPage_41, (String)Messages.CellImportResourcesPage_42);
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.InterruptedErrorMessageDialogTitle, (String)Messages.InterruptedErrorMessageDialogDescription);
        }
        return false;
    }

    protected boolean validateSourceGroup() {
        return this.sourceValid;
    }

    private String removeTrailingSlashes(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        if (path.charAt(path.length() - 1) == '/') {
            return this.removeTrailingSlashes(path.substring(0, path.length() - 1));
        }
        return path;
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = DeployPlugin.getDefault().getDialogSettings();
        this.destinationNameField.setText(settings.get(DeployPlugin.SETTING_IMPORT_DESTINATION));
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = DeployPlugin.getDefault().getDialogSettings();
        settings.put(DeployPlugin.SETTING_IMPORT_DESTINATION, this.getDestinationValue());
    }

    class VerifyPathTargetJob
    extends AbstractCellTargetJob {
        String path;
        boolean isDir;
        boolean hasPath;

        public VerifyPathTargetJob(String p, boolean isDirectory) {
            this.path = p;
            this.isDir = isDirectory;
            this.hasPath = false;
        }

        public void run() {
            try {
                IRemoteFileTools fileTools = this.executionManager.getRemoteFileTools();
                this.hasPath = this.isDir ? fileTools.hasDirectory(this.path) : fileTools.hasFile(this.path);
            }
            catch (RemoteConnectionException e) {
                this.exception = e;
                this.errorMessage = Messages.CellImportResourcesPage_0;
                this.hadError = true;
            }
            catch (RemoteOperationException e) {
                this.exception = e;
                this.errorMessage = Messages.CellImportResourcesPage_1;
                this.hadError = true;
            }
            catch (CancelException e) {
                this.exception = e;
                this.errorMessage = Messages.CellImportResourcesPage_2;
                this.hadError = true;
            }
        }

        public boolean doesPathExist() {
            return this.hasPath;
        }
    }
}

