/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.callhierarchy;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.callhierarchy.CHMultiDefNode;
import org.eclipse.cdt.internal.ui.callhierarchy.CHNode;
import org.eclipse.cdt.internal.ui.callhierarchy.CHReferenceInfo;
import org.eclipse.cdt.internal.ui.viewsupport.AsyncTreeContentProvider;
import org.eclipse.cdt.internal.ui.viewsupport.WorkingSetFilterUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CElementSet;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CalledByResult;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CallsToResult;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.ICallHierarchyService;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.ui.callhierarchy.RemoteCHViewPart;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.swt.widgets.Display;

public class CHContentProvider
extends AsyncTreeContentProvider {
    private static final IProgressMonitor NPM = new NullProgressMonitor();
    private boolean fComputeReferencedBy = true;
    private WorkingSetFilterUI fFilter;
    private RemoteCHViewPart fView;

    public CHContentProvider(RemoteCHViewPart view, Display disp) {
        super(disp);
        this.fView = view;
    }

    public Object getParent(Object element) {
        if (element instanceof CHNode) {
            CHNode node = (CHNode)element;
            return node.getParent();
        }
        return super.getParent(element);
    }

    protected Object[] syncronouslyComputeChildren(Object parentElement) {
        if (parentElement instanceof CHMultiDefNode) {
            return ((CHMultiDefNode)parentElement).getChildNodes();
        }
        if (parentElement instanceof CHNode) {
            CHNode node = (CHNode)parentElement;
            if (node.isRecursive() || node.getRepresentedDeclaration() == null) {
                return NO_CHILDREN;
            }
            if (this.fComputeReferencedBy ? node.isInitializer() : node.isVariableOrEnumerator() || node.isMacro()) {
                return NO_CHILDREN;
            }
        }
        return null;
    }

    protected Object[] asyncronouslyComputeChildren(Object parentElement, IProgressMonitor monitor) {
        try {
            if (parentElement instanceof ICElement) {
                return this.asyncComputeRoot((ICElement)parentElement);
            }
            if (parentElement instanceof CHNode) {
                CHNode node = (CHNode)parentElement;
                if (this.fComputeReferencedBy) {
                    return this.asyncronouslyComputeReferencedBy(node);
                }
                return this.asyncronouslyComputeRefersTo(node);
            }
        }
        catch (CoreException e) {
            CUIPlugin.log((Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return NO_CHILDREN;
    }

    private Object[] asyncComputeRoot(final ICElement input) throws CoreException, InterruptedException {
        final ICElement element = input;
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                CHContentProvider.this.fView.reportInputReplacement(input, element);
            }
        });
        ITranslationUnit tu = CModelUtil.getTranslationUnit((ICElement)element);
        return new Object[]{new CHNode(null, tu, 0L, element, -1)};
    }

    private Object[] asyncronouslyComputeReferencedBy(CHNode parent) throws CoreException, InterruptedException {
        IService indexingService;
        ICElement callee = parent.getRepresentedDeclaration();
        CalledByResult result = null;
        IProject project = callee.getCProject().getProject();
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
        IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
        if (serviceProvider instanceof IIndexServiceProvider) {
            ICallHierarchyService chService = ((IIndexServiceProvider)serviceProvider).getCallHierarchyService();
            result = chService.findCalledBy(Scope.WORKSPACE_ROOT_SCOPE, callee, NPM);
        }
        return this.createNodes(parent, result);
    }

    private Object[] asyncronouslyComputeRefersTo(CHNode parent) throws CoreException, InterruptedException {
        IService indexingService;
        ICElement caller = parent.getRepresentedDeclaration();
        CallsToResult result = null;
        IProject project = caller.getCProject().getProject();
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
        IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
        if (serviceProvider instanceof IIndexServiceProvider) {
            ICallHierarchyService chService = ((IIndexServiceProvider)serviceProvider).getCallHierarchyService();
            result = chService.findCalls(Scope.WORKSPACE_ROOT_SCOPE, caller, NPM);
        }
        return this.createNodes(parent, result);
    }

    public void setComputeReferencedBy(boolean value) {
        this.fComputeReferencedBy = value;
    }

    public boolean getComputeReferencedBy() {
        return this.fComputeReferencedBy;
    }

    public void setWorkingSetFilter(WorkingSetFilterUI filterUI) {
        this.fFilter = filterUI;
        this.recompute();
    }

    CHNode[] createNodes(CHNode node, CalledByResult result) throws CoreException {
        ArrayList<CHNode> nodes = new ArrayList<CHNode>();
        ICElement[] elements = result.getElements();
        int i = 0;
        while (i < elements.length) {
            IIndexName[] refs;
            ICElement element = elements[i];
            if (element != null && (this.fFilter == null || this.fFilter.isPartOfWorkingSet(element)) && (refs = result.getReferences(element)) != null && refs.length > 0) {
                CHNode newNode = this.createRefbyNode(node, element, refs);
                nodes.add(newNode);
            }
            ++i;
        }
        return nodes.toArray(new CHNode[nodes.size()]);
    }

    private CHNode createRefbyNode(CHNode parent, ICElement element, IIndexName[] refs) throws CoreException {
        ITranslationUnit tu = CModelUtil.getTranslationUnit((ICElement)element);
        IIndexFile file = refs[0].getFile();
        CHNode node = new CHNode(parent, tu, refs[0].getFile().getTimestamp(), element, file.getLinkageID());
        if (element instanceof IVariable || element instanceof IEnumerator) {
            node.setInitializer(true);
        }
        boolean readAccess = false;
        boolean writeAccess = false;
        int i = 0;
        while (i < refs.length) {
            IIndexName reference = refs[i];
            node.addReference(new CHReferenceInfo(reference.getNodeOffset(), reference.getNodeLength()));
            readAccess = readAccess || reference.isReadAccess();
            writeAccess = writeAccess || reference.isWriteAccess();
            ++i;
        }
        node.setRWAccess(readAccess, writeAccess);
        node.sortReferencesByOffset();
        return node;
    }

    CHNode[] createNodes(CHNode node, CallsToResult callsTo) throws CoreException {
        ITranslationUnit tu = CModelUtil.getTranslationUnit((ICElement)node.getRepresentedDeclaration());
        ArrayList<CHNode> result = new ArrayList<CHNode>();
        CElementSet[] elementSets = callsTo.getElementSets();
        int i = 0;
        while (i < elementSets.length) {
            CElementSet set = elementSets[i];
            if (!set.isEmpty()) {
                IIndexName[] refs = callsTo.getReferences(set);
                ICElement[] elements = set.getElements();
                if (elements.length > 0) {
                    CHNode childNode = this.createReftoNode(node, tu, elements, refs);
                    result.add(childNode);
                }
            }
            ++i;
        }
        return result.toArray(new CHNode[result.size()]);
    }

    private CHNode createReftoNode(CHNode parent, ITranslationUnit tu, ICElement[] elements, IIndexName[] references) throws CoreException {
        assert (elements.length > 0);
        long timestamp = references[0].getFile().getTimestamp();
        IIndexFile file = references[0].getFile();
        int linkageID = file.getLinkageID();
        Object node = elements.length == 1 ? new CHNode(parent, tu, timestamp, elements[0], linkageID) : new CHMultiDefNode(parent, tu, timestamp, elements, linkageID);
        boolean readAccess = false;
        boolean writeAccess = false;
        int i = 0;
        while (i < references.length) {
            IIndexName reference = references[i];
            node.addReference(new CHReferenceInfo(reference.getNodeOffset(), reference.getNodeLength()));
            readAccess = readAccess || reference.isReadAccess();
            writeAccess = writeAccess || reference.isWriteAccess();
            ++i;
        }
        node.sortReferencesByOffset();
        node.setRWAccess(readAccess, writeAccess);
        return node;
    }
}

