/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.pdt.xml.wizard.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.AbstractEventElement;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.Event;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroup;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroupForest;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventSubgroup;
import org.eclipse.ptp.cell.pdt.xml.debug.Debug;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.Messages;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.PdtEventTreeContentProvider;
import org.eclipse.ptp.utils.ui.swt.Frame;
import org.eclipse.ptp.utils.ui.swt.FrameMold;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PdtWizardSelectEventsPage
extends WizardPage {
    protected Frame generalGroupOptions;
    protected Button x86EnableProfile;
    protected Button ppeEnableProfile;
    protected Button speEnableProfile;
    protected CheckboxTreeViewer eventStatusTreeViewer;
    protected Group eventDescriptionGroup;
    protected Label eventDescriptionLabel;
    protected Boolean isCellArchictecture;
    private EventGroupForest eventGroupForest;

    public PdtWizardSelectEventsPage(Boolean isCell, EventGroupForest eventGroupForest) {
        super(PdtWizardSelectEventsPage.class.getName());
        this.setTitle(Messages.PdtWizardSelectEventsPage_Title);
        this.setDescription(Messages.PdtWizardSelectEventsPage_Description);
        this.isCellArchictecture = isCell;
        this.eventGroupForest = eventGroupForest;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setFont(font);
        FrameMold genOptMold = new FrameMold(Messages.PdtWizardSelectEventsPage_Frame_Title);
        genOptMold.addOption(FrameMold.HAS_FRAME);
        this.generalGroupOptions = new Frame(composite, genOptMold);
        this.generalGroupOptions.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        GridData butGridData = GridDataFactory.fillDefaults().create();
        butGridData.horizontalAlignment = 0x1000000;
        if (this.isCellArchictecture.booleanValue()) {
            this.ppeEnableProfile = new Button(this.generalGroupOptions.getTopUserReservedComposite(), 32);
            this.ppeEnableProfile.setLayoutData((Object)butGridData);
            this.ppeEnableProfile.setText(Messages.PdtWizardSelectEventsPage_CreateControl_Checkbox_PpeProfile);
            this.speEnableProfile = new Button(this.generalGroupOptions.getTopUserReservedComposite(), 32);
            this.speEnableProfile.setLayoutData((Object)GridDataFactory.copyData((GridData)butGridData));
            this.speEnableProfile.setText(Messages.PdtWizardSelectEventsPage_CreateControl_Checkbox_SpeProfile);
        } else {
            this.x86EnableProfile = new Button(this.generalGroupOptions.getTopUserReservedComposite(), 32);
            this.x86EnableProfile.setLayoutData((Object)butGridData);
            this.x86EnableProfile.setText(Messages.PdtWizardSelectEventsPage_CreateControl_Checkbox_X86Profile);
        }
        GridData gd = GridDataFactory.fillDefaults().create();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        gd.grabExcessVerticalSpace = true;
        this.eventStatusTreeViewer = new CheckboxTreeViewer(composite);
        this.eventStatusTreeViewer.setContentProvider((IContentProvider)new PdtEventTreeContentProvider());
        this.eventStatusTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.eventStatusTreeViewer.getControl().setLayoutData((Object)gd);
        GridData descLayDat = GridDataFactory.copyData((GridData)gd);
        this.eventDescriptionGroup = new Group(composite, 2048);
        this.eventDescriptionGroup.setLayoutData((Object)descLayDat);
        this.eventDescriptionGroup.setText(Messages.PdtWizardSelectEventsPage_CreateControl_Group_Description);
        GridLayout descGroupLay = new GridLayout(1, true);
        this.eventDescriptionGroup.setLayout((Layout)descGroupLay);
        GridData descLblLay = GridDataFactory.copyData((GridData)gd);
        this.eventDescriptionLabel = new Label((Composite)this.eventDescriptionGroup, 64);
        this.eventDescriptionLabel.setLayoutData((Object)descLblLay);
        this.eventStatusTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new TreeSelectionEvent());
        this.eventStatusTreeViewer.addCheckStateListener((ICheckStateListener)new TreeCheckedStateListener());
        this.initializeControls();
        this.setControl((Control)composite);
    }

    private void initializeControls() {
        this.fillEventTree();
    }

    protected void fillEventTree() {
        if (this.isCellArchictecture.booleanValue()) {
            this.eventStatusTreeViewer.setInput((Object)this.eventGroupForest);
        } else {
            this.eventDescriptionGroup.setEnabled(false);
        }
    }

    public EventGroupForest getEventGroups() {
        return this.eventGroupForest;
    }

    public void setChildGrayChecked(AbstractEventElement elem, boolean state) {
        block6: {
            block5: {
                if (!(elem instanceof EventGroup)) break block5;
                EventGroup eventGroup = (EventGroup)elem;
                for (EventSubgroup subgroup : eventGroup.getSubgroups()) {
                    if (state) {
                        this.eventStatusTreeViewer.setGrayChecked((Object)subgroup, true);
                    } else {
                        this.eventStatusTreeViewer.setGrayed((Object)subgroup, false);
                        this.eventStatusTreeViewer.setChecked((Object)subgroup, subgroup.getActive().booleanValue());
                    }
                    this.setChildGrayChecked(subgroup, state);
                }
                break block6;
            }
            if (!(elem instanceof EventSubgroup)) break block6;
            EventSubgroup eventSubgroup = (EventSubgroup)elem;
            for (Event event : eventSubgroup.getEvents()) {
                if (state) {
                    this.eventStatusTreeViewer.setGrayChecked((Object)event, true);
                    continue;
                }
                this.eventStatusTreeViewer.setGrayed((Object)event, false);
                this.eventStatusTreeViewer.setChecked((Object)event, event.getActive().booleanValue());
            }
        }
    }

    public boolean getX86EnableProfile() {
        return this.x86EnableProfile.getSelection();
    }

    public boolean getPpeEnableProfile() {
        return this.ppeEnableProfile.getSelection();
    }

    public boolean getSpeEnableProfile() {
        return this.speEnableProfile.getSelection();
    }

    public void refresh() {
        this.eventStatusTreeViewer.refresh();
    }

    protected class TreeCheckedStateListener
    implements ICheckStateListener {
        protected TreeCheckedStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Debug.read();
            try {
                AbstractEventElement elem = (AbstractEventElement)event.getElement();
                elem.setActive(event.getChecked());
                PdtWizardSelectEventsPage.this.setChildGrayChecked(elem, event.getChecked());
            }
            catch (Exception e) {
                Debug.POLICY.logError((Throwable)e);
            }
        }
    }

    protected class TreeSelectionEvent
    implements ISelectionChangedListener {
        protected TreeSelectionEvent() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Debug.read();
            try {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    AbstractEventElement eventElem = (AbstractEventElement)sel.getFirstElement();
                    if (eventElem == null) {
                        return;
                    }
                    if (eventElem instanceof EventGroup) {
                        PdtWizardSelectEventsPage.this.eventDescriptionLabel.setText(Messages.PdtWizardSelectEventsPage_SelectionChanged_Tree_EventGroupItem);
                    } else if (eventElem instanceof EventSubgroup) {
                        PdtWizardSelectEventsPage.this.eventDescriptionLabel.setText(Messages.PdtWizardSelectEventsPage_SelectionChanged_Tree_EventSubgroupItem);
                    } else {
                        Event pdtEvent = (Event)eventElem;
                        PdtWizardSelectEventsPage.this.eventDescriptionLabel.setText(pdtEvent.getDescription());
                    }
                }
            }
            catch (Exception e) {
                Debug.POLICY.logError((Throwable)e);
            }
        }
    }
}

