/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.core.attributes.ArrayAttribute;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.AbstractParallelLaunchConfigurationDelegate;
import org.eclipse.ptp.launch.internal.RuntimeProcess;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;

public class ParallelLaunchConfigurationDelegate
extends AbstractParallelLaunchConfigurationDelegate {
    protected void doCompleteJobLaunch(ILaunchConfiguration configuration, String mode, final IPLaunch launch, AttributeManager mgr, final IPDebugger debugger, final IPJob job) {
        launch.setAttribute(ElementAttributes.getIdAttributeDefinition().getId(), job.getID());
        if (mode.equals("debug")) {
            launch.setPJob(job);
            try {
                this.setDefaultSourceLocator((ILaunch)launch, configuration);
                final IProject project = this.verifyProject(configuration);
                final IPath execPath = this.verifyExecutablePath(configuration);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        IRunnableWithProgress runnable = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException("The job is cancelled.");
                                }
                                monitor.beginTask("Debugger has started, waiting for connection...", 1);
                                try {
                                    try {
                                        IPSession session = PTPDebugCorePlugin.getDebugModel().createDebugSession(debugger, launch, project, execPath);
                                        String app = ((StringAttribute)job.getAttribute((IAttributeDefinition)JobAttributes.getExecutableNameAttributeDefinition())).getValueAsString();
                                        String path = ((StringAttribute)job.getAttribute((IAttributeDefinition)JobAttributes.getExecutablePathAttributeDefinition())).getValueAsString();
                                        String cwd = ((StringAttribute)job.getAttribute((IAttributeDefinition)JobAttributes.getWorkingDirectoryAttributeDefinition())).getValueAsString();
                                        List args = ((ArrayAttribute)job.getAttribute((IAttributeDefinition)JobAttributes.getProgramArgumentsAttributeDefinition())).getValue();
                                        session.connectToDebugger(monitor, app, path, cwd, args.toArray(new String[args.size()]));
                                    }
                                    catch (CoreException e) {
                                        throw new InvocationTargetException(e);
                                    }
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        };
                        try {
                            new ProgressMonitorDialog(PTPLaunchPlugin.getActiveWorkbenchShell()).run(true, true, runnable);
                        }
                        catch (InterruptedException e) {
                            System.out.println("Debug job launch interrupted: " + e.getMessage());
                            ParallelLaunchConfigurationDelegate.this.terminateJob(job);
                        }
                        catch (InvocationTargetException e) {
                            String msg = e.getMessage();
                            Throwable t = e.getCause();
                            if (t != null) {
                                msg = t.getMessage();
                            }
                            System.out.println("Error completing debug job launch: " + msg);
                            PTPLaunchPlugin.errorDialog("Error completing debug job launch", t);
                            PTPLaunchPlugin.log(t);
                            ParallelLaunchConfigurationDelegate.this.terminateJob(job);
                        }
                    }
                });
            }
            catch (CoreException e) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PTPLaunchPlugin.errorDialog("Error completing launch", e.getStatus());
                    }
                });
                PTPLaunchPlugin.log(e);
                this.terminateJob(job);
            }
        } else {
            new RuntimeProcess(launch, job, null);
        }
    }

    protected void doCleanuoLaunch(ILaunchConfiguration configuration, String mode, IPLaunch launch, AttributeManager attrMgr, IPDebugger debugger, IPJob job) {
        if (debugger != null) {
            debugger.cleanup(configuration, attrMgr, launch);
        }
    }

    private void terminateJob(IPJob job) {
        try {
            IResourceManager rm = job.getQueue().getResourceManager();
            rm.terminateJob(job);
        }
        catch (CoreException e1) {
            PTPLaunchPlugin.log(e1);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!(launch instanceof IPLaunch)) {
            this.abort(Messages.ParallelLaunchConfigurationDelegate_Invalid_launch_object, null, 0);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 250);
        monitor.setTaskName(MessageFormat.format("{0} . . .", new Object[]{"Launching " + configuration.getName()}));
        if (monitor.isCanceled()) {
            return;
        }
        debugger = null;
        job = null;
        monitor.worked(10);
        monitor.subTask("Copying data . . .");
        attrManager = this.getAttributeManager(configuration, mode);
        this.copyExecutable(configuration, monitor);
        this.doPreLaunchSynchronization(configuration, monitor);
        this.switchPerspective(DebugUITools.getLaunchPerspective((ILaunchConfigurationType)configuration.getType(), (String)mode));
        try {
            if (!mode.equals("debug")) ** GOTO lbl28
            this.showPTPDebugView(IPTPDebugUIConstants.ID_VIEW_PARALLELDEBUG);
            monitor.subTask("Configuring debug setting . . .");
            debugConfig = this.getDebugConfig(configuration);
            debugger = debugConfig.getDebugger();
            debugger.initialize(configuration, attrManager, monitor);
            if (monitor.isCanceled()) {
                return;
            }
            try {
                debugger.getLaunchAttributes(configuration, attrManager);
lbl28:
                // 2 sources

                monitor.worked(10);
                monitor.subTask("Submitting the job . . .");
                this.submitJob(configuration, mode, (IPLaunch)launch, attrManager, debugger, monitor);
                monitor.worked(10);
            }
            catch (CoreException e) {
                if (mode.equals("debug")) {
                    PTPDebugCorePlugin.getDebugModel().shutdownSession(job);
                }
                if (e.getStatus().getCode() != 8) {
                    throw e;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void showPTPDebugView(final String viewID) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PTPLaunchPlugin.getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null) {
                        try {
                            page.showView(viewID, null, 3);
                        }
                        catch (PartInitException partInitException) {}
                    }
                }
            });
        }
    }

    protected void switchPerspective(final String perspectiveID) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PTPLaunchPlugin.getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null) {
                        if (page.getPerspective().getId().equals(perspectiveID)) {
                            return;
                        }
                        try {
                            window.getWorkbench().showPerspective(perspectiveID, window);
                        }
                        catch (WorkbenchException workbenchException) {}
                    }
                }
            });
        }
    }
}

