/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedNodeCollector
implements IBTreeVisitor,
IPDOMVisitor {
    private final PDOMLinkage linkage;
    private final char[] name;
    private final boolean prefixLookup;
    private final boolean caseSensitive;
    private IProgressMonitor monitor = null;
    private int monitorCheckCounter = 0;
    private List<PDOMNamedNode> nodes = new ArrayList<PDOMNamedNode>();

    public NamedNodeCollector(PDOMLinkage linkage, char[] name) {
        this(linkage, name, false, true);
    }

    public NamedNodeCollector(PDOMLinkage linkage, char[] name, boolean prefixLookup, boolean caseSensitive) {
        this.name = name;
        this.linkage = linkage;
        this.prefixLookup = prefixLookup;
        this.caseSensitive = caseSensitive;
    }

    public void setMonitor(IProgressMonitor pm) {
        this.monitor = pm;
    }

    @Override
    public final int compare(int record) throws CoreException {
        if (this.monitor != null) {
            this.checkCancelled();
        }
        IString rhsName = PDOMNamedNode.getDBName(this.linkage.getPDOM(), record);
        return this.compare(rhsName);
    }

    private int compare(IString rhsName) throws CoreException {
        if (this.prefixLookup) {
            int cmp = rhsName.comparePrefix(this.name, false);
            if (this.caseSensitive) {
                cmp = cmp == 0 ? rhsName.comparePrefix(this.name, true) : cmp;
            }
            return cmp;
        }
        int cmp = this.caseSensitive ? rhsName.compareCompatibleWithIgnoreCase(this.name) : rhsName.compare(this.name, false);
        return cmp;
    }

    @Override
    public final boolean visit(int record) throws CoreException {
        if (this.monitor != null) {
            this.checkCancelled();
        }
        if (record == 0) {
            return true;
        }
        PDOMNode node = this.linkage.getNode(record);
        if (node instanceof PDOMNamedNode) {
            return this.addNode((PDOMNamedNode)node);
        }
        return true;
    }

    protected boolean addNode(PDOMNamedNode node) throws CoreException {
        this.nodes.add(node);
        return true;
    }

    protected final List<PDOMNamedNode> getNodeList() {
        return this.nodes;
    }

    public final PDOMNamedNode[] getNodes() {
        return this.nodes.toArray(new PDOMNamedNode[this.nodes.size()]);
    }

    @Override
    public final boolean visit(IPDOMNode node) throws CoreException {
        PDOMNamedNode pb;
        if (this.monitor != null) {
            this.checkCancelled();
        }
        if (node instanceof PDOMNamedNode && this.compare((pb = (PDOMNamedNode)node).getDBName()) == 0) {
            this.addNode(pb);
        }
        return false;
    }

    private void checkCancelled() {
        if (++this.monitorCheckCounter % 4096 == 0 && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    @Override
    public final void leave(IPDOMNode node) throws CoreException {
    }
}

