/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.xlc;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.dom.lrparser.CLanguageKeywords;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.lrparser.xlc.XlcCPPScannerExtensionConfiguration;
import org.eclipse.cdt.core.lrparser.xlc.XlcCScannerExtensionConfiguration;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.util.CharArrayMap;

public class XlcKeywords
extends CLanguageKeywords {
    public static final XlcKeywords ALL_C_KEYWORDS = XlcKeywords.createC(true, true);
    public static final XlcKeywords ALL_CPP_KEYWORDS = XlcKeywords.createCPP(true, true, true, true);
    private final CharArrayMap<Integer> map = new CharArrayMap();
    private final ParserLanguage language;
    private String[] allKeywords = null;

    public static XlcKeywords createC(boolean supportVectors, boolean supportDecimalFloatingPoint) {
        XlcKeywords keywords = new XlcKeywords(ParserLanguage.C);
        CharArrayMap<Integer> map = keywords.map;
        if (supportVectors) {
            map.put("vector".toCharArray(), (Object)5);
            map.put("__vector".toCharArray(), (Object)5);
            map.put("pixel".toCharArray(), (Object)3);
            map.put("__pixel".toCharArray(), (Object)3);
            map.put("bool".toCharArray(), (Object)4);
        }
        if (supportDecimalFloatingPoint) {
            map.put("_Decimal32".toCharArray(), (Object)65);
            map.put("_Decimal64".toCharArray(), (Object)66);
            map.put("_Decimal128".toCharArray(), (Object)67);
        }
        return keywords;
    }

    public static XlcKeywords createCPP(boolean supportVectors, boolean supportDecimalFloatingPoint, boolean supportComplex, boolean supportRestrict) {
        XlcKeywords keywords = new XlcKeywords(ParserLanguage.CPP);
        CharArrayMap<Integer> map = keywords.map;
        if (supportVectors) {
            map.put("vector".toCharArray(), (Object)3);
            map.put("__vector".toCharArray(), (Object)3);
            map.put("pixel".toCharArray(), (Object)2);
            map.put("__pixel".toCharArray(), (Object)2);
        }
        if (supportDecimalFloatingPoint) {
            map.put("_Decimal32".toCharArray(), (Object)29);
            map.put("_Decimal64".toCharArray(), (Object)30);
            map.put("_Decimal128".toCharArray(), (Object)31);
        }
        if (supportComplex) {
            map.put("_Complex".toCharArray(), (Object)24);
        }
        if (supportRestrict) {
            map.put("restrict".toCharArray(), (Object)35);
            map.put("__restrict".toCharArray(), (Object)35);
            map.put("__restrict__".toCharArray(), (Object)35);
        }
        return keywords;
    }

    private XlcKeywords(ParserLanguage language) {
        super(language, XlcKeywords.getConfig(language));
        this.language = language;
    }

    private static IScannerExtensionConfiguration getConfig(ParserLanguage lang) {
        return lang.isCPP() ? XlcCPPScannerExtensionConfiguration.getInstance() : XlcCScannerExtensionConfiguration.getInstance();
    }

    public Integer getTokenKind(char[] keyword) {
        return (Integer)this.map.get(keyword);
    }

    public synchronized String[] getKeywords() {
        if (this.allKeywords == null) {
            IScannerExtensionConfiguration config = XlcKeywords.getConfig(this.language);
            CLanguageKeywords base = new CLanguageKeywords(this.language, config);
            String[] baseKeywords = base.getKeywords();
            ArrayList<String> keywords = new ArrayList<String>();
            keywords.addAll(Arrays.asList(baseKeywords));
            for (char[] keyword : this.map.keys()) {
                keywords.add(String.valueOf(keyword));
            }
            this.allKeywords = keywords.toArray(new String[keywords.size()]);
        }
        return this.allKeywords;
    }
}

