/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.model.IWorkingCopyProvider;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.dom.SavedCodeReaderFactory;
import org.eclipse.cdt.internal.core.parser.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialWorkingCopyCodeReaderFactory
implements ICodeReaderFactory {
    private final IWorkingCopyProvider provider;
    private ICodeReaderCache cache = null;

    public PartialWorkingCopyCodeReaderFactory(IWorkingCopyProvider provider) {
        this.provider = provider;
        this.cache = SavedCodeReaderFactory.getInstance().getCodeReaderCache();
    }

    @Override
    public int getUniqueIdentifier() {
        return 1;
    }

    @Override
    public CodeReader createCodeReaderForTranslationUnit(String path) {
        return this.checkWorkingCopyThenCache(path);
    }

    public CodeReader createCodeReaderForTranslationUnit(ITranslationUnit tu) {
        return new CodeReader(tu.getPath().toOSString(), tu.getContents());
    }

    protected CodeReader checkWorkingCopyThenCache(String path) {
        char[] buffer = ParserUtil.findWorkingCopyBuffer(path, this.createWorkingCopyIterator());
        if (buffer != null) {
            return new CodeReader(path, buffer);
        }
        return this.cache.get(path);
    }

    @Override
    public CodeReader createCodeReaderForInclusion(String path) {
        return this.cache.get(path);
    }

    protected Iterator<IWorkingCopy> createWorkingCopyIterator() {
        if (this.provider == null) {
            return EmptyIterator.empty();
        }
        return Arrays.asList(this.provider.getWorkingCopies()).iterator();
    }

    @Override
    public ICodeReaderCache getCodeReaderCache() {
        return this.cache;
    }
}

