/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPClassTemplatePartialSpecialization
extends CPPClassTemplate
implements ICPPClassTemplatePartialSpecialization,
ICPPSpecialization {
    private IType[] arguments;

    public CPPClassTemplatePartialSpecialization(ICPPASTTemplateId name) {
        super(name);
    }

    public IType[] getArguments() {
        if (this.arguments == null) {
            ICPPASTTemplateId id = (ICPPASTTemplateId)this.getTemplateName();
            this.arguments = CPPTemplates.createTemplateArgumentArray(id);
        }
        return this.arguments;
    }

    public ICPPClassTemplate getPrimaryClassTemplate() {
        ICPPASTTemplateId id = (ICPPASTTemplateId)this.getTemplateName();
        return (ICPPClassTemplate)id.getTemplateName().resolveBinding();
    }

    public IBinding instantiate(IType[] args) {
        ICPPSpecialization instance = this.getInstance(args = SemanticUtil.getSimplifiedTypes(args));
        if (instance != null) {
            return instance;
        }
        ObjectMap argMap = CPPTemplates.deduceTemplateArguments(this.getArguments(), args, true);
        if (argMap == null) {
            return null;
        }
        if (CPPTemplates.containsDependentArg(argMap)) {
            return this.deferredInstance(argMap, args);
        }
        ICPPTemplateParameter[] params = this.getTemplateParameters();
        int numParams = params.length;
        int i = 0;
        while (i < numParams) {
            if (params[i] instanceof IType && !argMap.containsKey(params[i])) {
                return null;
            }
            ++i;
        }
        instance = (ICPPTemplateInstance)CPPTemplates.createInstance((ICPPScope)this.getScope(), this, argMap, args);
        this.addSpecialization(args, instance);
        return instance;
    }

    public IBinding getSpecializedBinding() {
        return this.getPrimaryClassTemplate();
    }

    public ObjectMap getArgumentMap() {
        ICPPTemplateParameter[] params;
        IType[] arg = this.getArguments();
        try {
            params = this.getPrimaryClassTemplate().getTemplateParameters();
        }
        catch (DOMException dOMException) {
            return ObjectMap.EMPTY_MAP;
        }
        int len = Math.min(params.length, arg.length);
        ObjectMap map = new ObjectMap(len);
        int i = 0;
        while (i < len) {
            map.put(params[i], arg[i]);
            ++i;
        }
        return map;
    }
}

