/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPMethod
extends CPPFunction
implements ICPPMethod {
    public CPPMethod(ICPPASTFunctionDeclarator declarator) {
        super(declarator);
    }

    public IASTDeclaration getPrimaryDeclaration() throws DOMException {
        if (this.declarations != null) {
            ICPPASTFunctionDeclarator[] iCPPASTFunctionDeclaratorArray = this.declarations;
            int n = this.declarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator dtor = iCPPASTFunctionDeclaratorArray[n2];
                if (dtor == null) break;
                IASTDeclaration decl = (IASTDeclaration)(dtor = CPPVisitor.findOutermostDeclarator(dtor)).getParent();
                if (decl.getParent() instanceof ICPPASTCompositeTypeSpecifier) {
                    return decl;
                }
                ++n2;
            }
        }
        char[] myName = this.getNameCharArray();
        ICPPClassScope scope = (ICPPClassScope)this.getScope();
        ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)ASTInternal.getPhysicalNodeOfScope(scope);
        if (compSpec != null) {
            IASTDeclaration[] members;
            IASTDeclaration[] iASTDeclarationArray = members = compSpec.getMembers();
            int n = members.length;
            int n3 = 0;
            while (n3 < n) {
                IASTFunctionDeclarator declarator;
                IASTName name;
                IASTDeclaration member = iASTDeclarationArray[n3];
                if (member instanceof IASTSimpleDeclaration) {
                    IASTDeclarator[] dtors;
                    IASTDeclarator[] iASTDeclaratorArray = dtors = ((IASTSimpleDeclaration)member).getDeclarators();
                    int n4 = dtors.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IASTDeclarator dtor = iASTDeclaratorArray[n5];
                        IASTName name2 = CPPVisitor.findInnermostDeclarator(dtor).getName();
                        if (CharArrayUtils.equals(name2.toCharArray(), myName) && name2.resolveBinding() == this) {
                            return member;
                        }
                        ++n5;
                    }
                } else if (member instanceof IASTFunctionDefinition && CharArrayUtils.equals((name = CPPVisitor.findInnermostDeclarator(declarator = ((IASTFunctionDefinition)member).getDeclarator()).getName()).toCharArray(), myName) && name.resolveBinding() == this) {
                    return member;
                }
                ++n3;
            }
        }
        return null;
    }

    public int getVisibility() throws DOMException {
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl == null) {
            ICPPClassType cls;
            IScope scope = this.getScope();
            if (scope instanceof ICPPClassScope && (cls = ((ICPPClassScope)scope).getClassType()) != null) {
                return cls.getKey() == 3 ? 3 : 1;
            }
            return 3;
        }
        IASTCompositeTypeSpecifier cls = (IASTCompositeTypeSpecifier)decl.getParent();
        IASTDeclaration[] members = cls.getMembers();
        ICPPASTVisibilityLabel vis = null;
        IASTDeclaration[] iASTDeclarationArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration member = iASTDeclarationArray[n2];
            if (member instanceof ICPPASTVisibilityLabel) {
                vis = (ICPPASTVisibilityLabel)member;
            } else if (member == decl) break;
            ++n2;
        }
        if (vis != null) {
            return vis.getVisibility();
        }
        if (cls.getKey() == 3) {
            return 3;
        }
        return 1;
    }

    public ICPPClassType getClassOwner() throws DOMException {
        ICPPClassScope scope = (ICPPClassScope)this.getScope();
        return scope.getClassType();
    }

    protected IASTName getASTName() {
        IASTDeclarator dtor = this.declarations != null && this.declarations.length > 0 ? this.declarations[0] : this.definition;
        IASTName name = (dtor = CPPVisitor.findInnermostDeclarator(dtor)).getName();
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
            name = ns[ns.length - 1];
        }
        return name;
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.getASTName());
    }

    public boolean isVirtual() throws DOMException {
        ICPPASTDeclSpecifier declSpec;
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl != null && (declSpec = this.getDeclSpec(decl)) != null) {
            return declSpec.isVirtual();
        }
        return false;
    }

    protected ICPPASTDeclSpecifier getDeclSpec(IASTDeclaration decl) {
        ICPPASTDeclSpecifier declSpec = null;
        if (decl instanceof IASTSimpleDeclaration) {
            declSpec = (ICPPASTDeclSpecifier)((IASTSimpleDeclaration)decl).getDeclSpecifier();
        } else if (decl instanceof IASTFunctionDefinition) {
            declSpec = (ICPPASTDeclSpecifier)((IASTFunctionDefinition)decl).getDeclSpecifier();
        }
        return declSpec;
    }

    public boolean isInline() throws DOMException {
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl instanceof IASTFunctionDefinition) {
            return true;
        }
        if (decl == null) {
            return false;
        }
        IASTDeclSpecifier declSpec = ((IASTSimpleDeclaration)decl).getDeclSpecifier();
        return declSpec.isInline();
    }

    public boolean isMutable() {
        return CPPMethod.hasStorageClass(this, 6);
    }

    public boolean isDestructor() {
        char[] name = this.getNameCharArray();
        return name.length > 1 && name[0] == '~';
    }

    public boolean isImplicit() {
        return false;
    }

    public static class CPPMethodProblem
    extends CPPFunction.CPPFunctionProblem
    implements ICPPMethod {
        public CPPMethodProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public int getVisibility() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPClassType getClassOwner() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isStatic() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isVirtual() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isDestructor() {
            char[] name = this.getNameCharArray();
            return name.length > 1 && name[0] == '~';
        }

        public boolean isImplicit() {
            return false;
        }
    }
}

