/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.core.runtime.CoreException;

public class IndexCPPSignatureUtil {
    public static String getSignature(IBinding binding) throws CoreException, DOMException {
        ICPPSpecialization spec;
        StringBuffer buffer = new StringBuffer();
        if (binding instanceof ICPPTemplateInstance) {
            ICPPTemplateInstance inst = (ICPPTemplateInstance)binding;
            buffer.append(IndexCPPSignatureUtil.getTemplateArgString(inst.getArguments(), true));
        } else if (binding instanceof ICPPClassTemplatePartialSpecialization) {
            ICPPClassTemplatePartialSpecialization partial = (ICPPClassTemplatePartialSpecialization)binding;
            buffer.append(IndexCPPSignatureUtil.getTemplateArgString(partial.getArguments(), false));
        } else if (binding instanceof ICPPSpecialization && !((spec = (ICPPSpecialization)binding) instanceof ICPPTemplateDefinition) && spec.getSpecializedBinding() instanceof ICPPTemplateDefinition) {
            ICPPTemplateDefinition template = (ICPPTemplateDefinition)spec.getSpecializedBinding();
            ICPPTemplateParameter[] params = template.getTemplateParameters();
            ObjectMap argMap = spec.getArgumentMap();
            IType[] args = new IType[params.length];
            int i = 0;
            while (i < params.length) {
                args[i] = (IType)argMap.get(params[i]);
                ++i;
            }
            buffer.append(IndexCPPSignatureUtil.getTemplateArgString(args, false));
        }
        if (binding instanceof IFunction) {
            IFunction function = (IFunction)binding;
            buffer.append(IndexCPPSignatureUtil.getFunctionParameterString(function.getType()));
        }
        return buffer.toString();
    }

    private static String getTemplateArgString(IType[] types, boolean qualifyTemplateParameters) throws CoreException, DOMException {
        StringBuilder buffer = new StringBuilder();
        buffer.append('<');
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                buffer.append(',');
            }
            IType type = types[i];
            if (qualifyTemplateParameters && type instanceof ICPPTemplateParameter) {
                ArrayList<IBinding> parents = new ArrayList<IBinding>();
                IScope parentScope = ((ICPPTemplateParameter)((Object)type)).getScope();
                IBinding lastBinding = null;
                while (parentScope != null) {
                    IBinding binding = IndexCPPSignatureUtil.getBindingForScope(parentScope);
                    if (binding != null && !binding.equals(lastBinding)) {
                        lastBinding = binding;
                        parents.add(lastBinding);
                    }
                    parentScope = parentScope.getParent();
                }
                Collections.reverse(parents);
                for (IBinding binding : parents) {
                    if (binding == null) continue;
                    buffer.append(binding.getNameCharArray());
                    if (binding instanceof ICPPSpecialization) {
                        ICPPSpecialization spec = (ICPPSpecialization)binding;
                        IndexCPPSignatureUtil.appendTemplateArgs(spec.getArgumentMap().valueArray(), buffer);
                    }
                    buffer.append("::");
                }
                buffer.append(((ICPPTemplateParameter)((Object)type)).getName());
            } else {
                buffer.append(ASTTypeUtil.getType(type));
            }
            ++i;
        }
        buffer.append('>');
        return buffer.toString();
    }

    private static IBinding getBindingForScope(IScope parentScope) throws DOMException {
        IBinding binding = null;
        if (parentScope instanceof IIndexScope) {
            binding = ((IIndexScope)parentScope).getScopeBinding();
        } else {
            IName scopeName = parentScope.getScopeName();
            if (scopeName instanceof IASTName) {
                binding = ((IASTName)scopeName).resolveBinding();
            }
        }
        return binding;
    }

    private static void appendTemplateArgs(Object[] values, StringBuilder buffer) {
        boolean needcomma = false;
        buffer.append('<');
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object val = objectArray[n2];
            if (val instanceof IType) {
                if (needcomma) {
                    buffer.append(',');
                }
                needcomma = true;
                buffer.append(ASTTypeUtil.getType((IType)val));
            }
            ++n2;
        }
        buffer.append('>');
    }

    private static String getFunctionParameterString(IFunctionType fType) throws DOMException {
        IType[] types = fType.getParameterTypes();
        if (types.length == 1 && types[0] instanceof IBasicType && ((IBasicType)types[0]).getType() == 1) {
            types = new IType[]{};
        }
        StringBuffer result = new StringBuffer();
        result.append('(');
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                result.append(',');
            }
            result.append(ASTTypeUtil.getType(types[i]));
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    public static Integer getSignatureHash(IBinding binding) throws CoreException, DOMException {
        String sig = IndexCPPSignatureUtil.getSignature(binding);
        return sig.length() == 0 ? null : new Integer(sig.hashCode());
    }

    public static int compareSignatures(IBinding a, IBinding b) {
        try {
            int siga = IndexCPPSignatureUtil.getSignature(a).hashCode();
            int sigb = IndexCPPSignatureUtil.getSignature(b).hashCode();
            return siga < sigb ? -1 : (siga > sigb ? 1 : 0);
        }
        catch (CoreException ce) {
            CCorePlugin.log((Throwable)ce);
        }
        catch (DOMException de) {
            CCorePlugin.log((Throwable)de);
        }
        return 0;
    }
}

