/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;

public abstract class ASTNode
implements IASTNode {
    private static final IASTNodeLocation[] EMPTY_LOCATION_ARRAY = new IASTNodeLocation[0];
    private IASTNode parent;
    private ASTNodeProperty property;
    private int length;
    private int offset;
    private IASTNodeLocation[] locations = null;
    private IASTFileLocation fileLocation = null;

    public IASTNode getParent() {
        return this.parent;
    }

    public void setParent(IASTNode node) {
        this.parent = node;
    }

    public ASTNodeProperty getPropertyInParent() {
        return this.property;
    }

    public void setPropertyInParent(ASTNodeProperty property) {
        this.property = property;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.locations = null;
    }

    public void setLength(int length) {
        this.length = length;
        this.locations = null;
    }

    public void setOffsetAndLength(int offset, int length) {
        this.offset = offset;
        this.length = length;
        this.locations = null;
    }

    public void setOffsetAndLength(ASTNode node) {
        this.setOffsetAndLength(node.getOffset(), node.getLength());
    }

    public IASTNodeLocation[] getNodeLocations() {
        if (this.locations != null) {
            return this.locations;
        }
        if (this.length == 0) {
            this.locations = EMPTY_LOCATION_ARRAY;
        } else {
            ILocationResolver l;
            IASTTranslationUnit tu = this.getTranslationUnit();
            if (tu != null && (l = (ILocationResolver)tu.getAdapter(ILocationResolver.class)) != null) {
                this.locations = l.getLocations(this.offset, this.length);
            }
        }
        return this.locations;
    }

    public IASTImageLocation getImageLocation() {
        ILocationResolver l;
        IASTTranslationUnit tu = this.getTranslationUnit();
        if (tu != null && (l = (ILocationResolver)tu.getAdapter(ILocationResolver.class)) != null) {
            return l.getImageLocation(this.offset, this.length);
        }
        return null;
    }

    public String getRawSignature() {
        ILocationResolver lr;
        IASTFileLocation floc = this.getFileLocation();
        IASTTranslationUnit ast = this.getTranslationUnit();
        if (floc != null && ast != null && (lr = (ILocationResolver)ast.getAdapter(ILocationResolver.class)) != null) {
            return new String(lr.getUnpreprocessedSignature(this.getFileLocation()));
        }
        return "";
    }

    public String getContainingFilename() {
        if (this.offset <= 0 && (this.length == 0 || this.offset < 0)) {
            IASTNode parent = this.getParent();
            if (parent == null) {
                if (this instanceof IASTTranslationUnit) {
                    return ((IASTTranslationUnit)((Object)this)).getFilePath();
                }
                return "";
            }
            return parent.getContainingFilename();
        }
        return this.getTranslationUnit().getContainingFilename(this.offset);
    }

    public IASTFileLocation getFileLocation() {
        if (this.fileLocation != null) {
            return this.fileLocation;
        }
        if (this.offset <= 0 && (this.length == 0 || this.offset < 0)) {
            return null;
        }
        IASTTranslationUnit ast = this.getTranslationUnit();
        if (ast != null) {
            ILocationResolver lr = (ILocationResolver)ast.getAdapter(ILocationResolver.class);
            this.fileLocation = lr != null ? lr.getMappedFileLocation(this.offset, this.length) : ast.flattenLocationsToFile(this.getNodeLocations());
        }
        return this.fileLocation;
    }

    public boolean isPartOfTranslationUnitFile() {
        ILocationResolver lr;
        IASTTranslationUnit ast = this.getTranslationUnit();
        if (ast != null && (lr = (ILocationResolver)ast.getAdapter(ILocationResolver.class)) != null) {
            return lr.isPartOfTranslationUnitFile(this.offset);
        }
        return false;
    }

    public IASTTranslationUnit getTranslationUnit() {
        return this.parent != null ? this.parent.getTranslationUnit() : null;
    }

    public boolean accept(ASTVisitor visitor) {
        return true;
    }

    public boolean contains(IASTNode node) {
        if (node instanceof ASTNode) {
            ASTNode astNode = (ASTNode)node;
            return this.offset <= astNode.offset && astNode.offset + astNode.length <= this.offset + this.length;
        }
        return false;
    }
}

