/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.internal.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.core.exception.UnableToForwardPortException;

public class LocalConnection
implements IRemoteConnection {
    private String name;
    private String address;
    private String username;
    private boolean connected;
    private IRemoteConnectionManager conMgr;
    private final IRemoteConnection connection = this;

    public LocalConnection(IRemoteConnectionManager conMgr) {
        this.conMgr = conMgr;
        this.name = "Local";
        this.address = "localhost";
        this.username = System.getProperty("user.name");
        this.connected = false;
    }

    public void close(IProgressMonitor monitor) {
        this.connected = false;
        this.conMgr.fireConnectionChangeEvent(new IRemoteConnectionChangeEvent(){

            public IRemoteConnection getConnection() {
                return LocalConnection.this.connection;
            }

            public int getType() {
                return 1;
            }
        });
    }

    public void forwardLocalPort(int localPort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException("Port forwarding not supported");
    }

    public int forwardLocalPort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException("Port forwarding not supported");
    }

    public void forwardRemotePort(int remotePort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException("Port forwarding not supported");
    }

    public int forwardRemotePort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException("Port forwarding not supported");
    }

    public String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isOpen() {
        return this.connected;
    }

    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        this.connected = true;
        this.conMgr.fireConnectionChangeEvent(new IRemoteConnectionChangeEvent(){

            public IRemoteConnection getConnection() {
                return LocalConnection.this.connection;
            }

            public int getType() {
                return 2;
            }
        });
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean supportsTCPPortForwarding() {
        return false;
    }
}

