/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.ui.console;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.ptp.cell.utils.stream.IStreamListener;
import org.eclipse.ptp.cell.utils.stream.StreamObserver;
import org.eclipse.ptp.cell.utils.terminal.AbstractTerminalProvider;
import org.eclipse.ptp.cell.utils.terminal.AbstractTerminalReceiver;
import org.eclipse.ptp.cell.utils.terminal.ITerminalProvider;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class TerminalToConsoleBridge
extends AbstractTerminalReceiver {
    IOConsole console;
    IOConsoleInputStream fromConsoleStream;
    IOConsoleOutputStream toConsoleStream;
    StreamObserver consoleInputObserver;
    ConsoleListener consoleListener;
    ITerminalProvider terminalProvider;

    public TerminalToConsoleBridge(ITerminalProvider provider, IOConsole console, String name) {
        super(provider);
        if (name == null) {
            name = this.getClass().getName();
        }
        this.console = console;
        this.fromConsoleStream = console.getInputStream();
        this.toConsoleStream = console.newOutputStream();
        this.consoleListener = new ConsoleListener(this);
        this.consoleInputObserver = new StreamObserver((InputStream)this.fromConsoleStream, this.consoleListener, name);
        this.consoleInputObserver.start();
        this.terminalProvider = provider;
        this.terminalProvider.addListener(this);
    }

    public void disconnect() {
        this.terminalProvider.removeListener(this);
        this.consoleInputObserver.interrupt();
        this.terminalProvider = null;
        this.consoleInputObserver = null;
        this.consoleListener = null;
        this.fromConsoleStream = null;
        this.toConsoleStream = null;
    }

    public TerminalToConsoleBridge(AbstractTerminalProvider terminalProvider, IOConsole console) {
        this(terminalProvider, console, null);
    }

    public void receiveData(byte[] bytes, int length) {
        try {
            this.toConsoleStream.write(bytes, 0, length);
        }
        catch (IOException iOException) {}
    }

    public void receiveError(byte[] bytes, int length) {
        try {
            this.toConsoleStream.write(bytes, 0, length);
        }
        catch (IOException iOException) {}
    }

    public void receiveMetaMessage(String message) {
        try {
            this.toConsoleStream.write("( INFO: ");
            this.toConsoleStream.write(message);
            this.toConsoleStream.write(")\n");
        }
        catch (IOException iOException) {}
    }

    class ConsoleListener
    implements IStreamListener {
        TerminalToConsoleBridge bridge;

        public ConsoleListener(TerminalToConsoleBridge bridge) {
            this.bridge = bridge;
        }

        public void newBytes(byte[] bytes, int length) {
            this.bridge.writeData(bytes, length);
        }

        public void streamClosed() {
        }

        public void streamError(Exception e) {
        }
    }
}

