/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.utils.linux.packagemanager.rpm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.ptp.cell.utils.debug.Debug;
import org.eclipse.ptp.cell.utils.linux.packagemanager.rpm.RPMPackageManagerMessages;
import org.eclipse.ptp.cell.utils.packagemanager.PackageManager;
import org.eclipse.ptp.cell.utils.process.ProcessController;

public class RPMPackageManager
implements PackageManager {
    protected static final String PROCESS_NAME = "RPM";
    protected static final String RPM = "rpm";
    protected static final String RPM_QUERY_FLAG = "-q";
    protected static final String RPM_QUERY_FORMAT = "--queryformat %{NAME}\\n";
    protected static final String RPM_QUERY_LIST_FLAG = "-ql";
    protected static final long TIMEOUT = 2000L;
    protected static final long CACHE_EXPIRE_DATE = 30000L;
    private static RPMPackageManager instance = null;
    private Map packageInformationCache = new HashMap();

    private RPMPackageManager() {
    }

    private StringBuffer addPackage(StringBuffer packages, String pack) {
        if (packages == null) {
            packages = new StringBuffer();
        } else {
            packages.append(" ");
        }
        return packages.append(pack);
    }

    public static synchronized RPMPackageManager getDefault() {
        if (instance == null) {
            instance = new RPMPackageManager();
        }
        return instance;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean query(String pack) {
        Debug.POLICY.enter(Debug.DEBUG_LINUX, new Object[]{pack});
        String[] arg = new String[]{pack};
        boolean result = this.queryAll(arg);
        Debug.POLICY.exit(Debug.DEBUG_LINUX, result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean queryAll(String[] packs) {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_LINUX, new Object[]{packs.toString()});
        long currentTime = System.currentTimeMillis();
        StringBuffer packages = null;
        int i = 0;
        while (i < packs.length) {
            PackageInformation packageInformation = (PackageInformation)this.packageInformationCache.get(packs[i]);
            if (packageInformation != null) {
                if (packageInformation.getExpireDate() > currentTime) {
                    Debug.POLICY.trace(Debug.DEBUG_LINUX, "Query package: {0} (cached, recent)", packs[i]);
                    if (!packageInformation.isInstalled()) {
                        Debug.POLICY.trace(Debug.DEBUG_LINUX, "Known that package is not installed {0}", packs[i]);
                        Debug.POLICY.exit(Debug.DEBUG_LINUX, false);
                        return false;
                    }
                    Debug.POLICY.trace(Debug.DEBUG_LINUX, "Known that package is installed {0}", packs[i]);
                } else {
                    Debug.POLICY.trace(Debug.DEBUG_LINUX, "Query package: {0} (cached, expired)", packs[i]);
                    packages = this.addPackage(packages, packs[i]);
                }
            } else {
                Debug.POLICY.trace(Debug.DEBUG_LINUX, "Query package: {0} (not cached)", packs[i]);
                packages = this.addPackage(packages, packs[i]);
            }
            ++i;
        }
        if (packages == null) {
            Debug.POLICY.exit(Debug.DEBUG_LINUX, true);
            return true;
        }
        String command = "rpm -q --queryformat %{NAME}\\n " + packages;
        try {
            Debug.POLICY.trace(Debug.DEBUG_LINUX, command);
            Process process = ProcessFactory.getFactory().exec(command);
            ProcessController processController = new ProcessController(PROCESS_NAME, process, 2000L);
            processController.start();
            BufferedReader processOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Pattern p = Pattern.compile(RPMPackageManagerMessages.rpmIsNotInstalledErrorMessagePattern);
            String line = processOutput.readLine();
            Debug.POLICY.trace(Debug.DEBUG_LINUX_MORE, line);
            while (line != null) {
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    this.packageInformationCache.put(m.group(1), new PackageInformation(m.group(1), false, currentTime + 30000L));
                    Debug.POLICY.trace(Debug.DEBUG_LINUX, "Package is not installed: {0}", m.group(1));
                    Debug.POLICY.exit(Debug.DEBUG_LINUX, false);
                    return false;
                }
                this.packageInformationCache.put(line, new PackageInformation(line, true, currentTime + 30000L));
                Debug.POLICY.trace(Debug.DEBUG_LINUX, "Package is installed: {0}", line);
                line = processOutput.readLine();
                Debug.POLICY.trace(Debug.DEBUG_LINUX_MORE, line);
            }
        }
        catch (IOException e) {
            Debug.POLICY.error(Debug.DEBUG_LINUX, e.getMessage());
            Debug.POLICY.exit(Debug.DEBUG_LINUX, false);
            Debug.POLICY.logError(e, RPMPackageManagerMessages.RPMPackageManager_FailedExcecution, command);
            return false;
        }
        Debug.POLICY.exit(Debug.DEBUG_LINUX, true);
        return true;
    }

    public boolean queryAll(String packs, String delimiter) {
        return this.queryAll(packs.split(delimiter));
    }

    public List queryList(String pack) {
        ArrayList<String> fileList;
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_LINUX, new Object[]{pack});
        String command = "rpm -ql " + pack;
        try {
            Debug.POLICY.trace(Debug.DEBUG_LINUX, command);
            Process process = ProcessFactory.getFactory().exec(command);
            ProcessController processController = new ProcessController(PROCESS_NAME, process, 2000L);
            processController.start();
            BufferedReader processOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = processOutput.readLine();
            Debug.POLICY.trace(Debug.DEBUG_LINUX_MORE, line);
            if (line.endsWith(RPMPackageManagerMessages.rpmIsNotInstalledErrorMessage)) {
                Debug.POLICY.trace(Debug.DEBUG_LINUX, "Package {0} is not installed", pack);
                Debug.POLICY.exit(Debug.DEBUG_LINUX);
                return new ArrayList();
            }
            fileList = new ArrayList<String>();
            fileList.add(line);
            while ((line = processOutput.readLine()) != null) {
                fileList.add(line);
            }
            Debug.POLICY.trace(Debug.DEBUG_LINUX, "Added {0} files to list", fileList.size());
            if (process.waitFor() != 0) {
                Debug.POLICY.trace(Debug.DEBUG_LINUX, "Process failed with exit code {0}", process.exitValue());
                processController.interrupt();
                Debug.POLICY.exit(Debug.DEBUG_LINUX);
                return new ArrayList();
            }
            processController.interrupt();
        }
        catch (InterruptedException e) {
            Debug.POLICY.error(Debug.DEBUG_LINUX, e);
            Debug.POLICY.exit(Debug.DEBUG_LINUX);
            return new ArrayList();
        }
        catch (IOException e) {
            Debug.POLICY.error(Debug.DEBUG_LINUX, e);
            Debug.POLICY.exit(Debug.DEBUG_LINUX);
            Debug.POLICY.logError(e, RPMPackageManagerMessages.RPMPackageManager_FailedExcecution, command);
            return new ArrayList();
        }
        Debug.POLICY.exit(Debug.DEBUG_LINUX, ((Object)fileList).toString());
        return fileList;
    }

    public String searchFileInQueryListAndReturnInitialPathSegments(String pack, String pathEnd) {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_LINUX, new Object[]{pack, pathEnd});
        for (String file : this.queryList(pack)) {
            int lastIndexOfLastSegments = file.lastIndexOf(pathEnd);
            if (lastIndexOfLastSegments == -1) continue;
            String result = file.substring(0, lastIndexOfLastSegments);
            Debug.POLICY.exit(Debug.DEBUG_LINUX, result);
            return result;
        }
        Debug.POLICY.exit(Debug.DEBUG_LINUX, null);
        return null;
    }

    public String searchFileInQueryListAndReturnFullPath(String pack, String pathEnd) {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_LINUX, new Object[]{pack, pathEnd});
        for (String file : this.queryList(pack)) {
            if (!file.endsWith(pathEnd)) continue;
            Debug.POLICY.exit(Debug.DEBUG_LINUX, file);
            return file;
        }
        Debug.POLICY.exit(Debug.DEBUG_LINUX, null);
        return null;
    }

    protected class PackageInformation {
        private String name;
        private boolean isInstalled;
        private long expireDate;

        public PackageInformation(String name, boolean isInstalled, long expireDate) {
            this.name = name;
            this.isInstalled = isInstalled;
            this.expireDate = expireDate;
        }

        public long getExpireDate() {
            return this.expireDate;
        }

        public boolean isInstalled() {
            return this.isInstalled;
        }

        public String getName() {
            return this.name;
        }
    }
}

