/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.wizards.wizardPages;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.pldt.wizards.MpiWizardsPlugin;
import org.eclipse.ptp.pldt.wizards.wizardPages.OpenMPProjectWizardPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMPProjectProcess
extends ProcessRunner {
    private static final boolean traceOn = false;
    private boolean wizTraceOn = false;
    private Map<String, String> valueStore;

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        if (this.wizTraceOn) {
            System.out.println("OpenMPProjectProcess().run()...");
        }
        this.valueStore = template.getValueStore();
        String pageID = "org.eclipse.ptp.pldt.wizards.wizardPages.OpenMPProjectWizardPage";
        String obj = this.getNewPropValue(pageID, "doOpenMPincludes", null);
        boolean doOpenMPIncludes = OpenMPProjectWizardPage.getDefaultUseOpenMPIncludes();
        if (obj != null) {
            doOpenMPIncludes = Boolean.valueOf(obj);
        }
        if (!doOpenMPIncludes) {
            return;
        }
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(this.valueStore.get("projectName"));
        if (!proj.exists()) {
            System.out.println("Project does not exist!. Quitting. No OpenMP info added to project.");
            return;
        }
        String propID = "includePath";
        String newIncludePath = this.getNewPropValue(pageID, propID, "c:/openmp/include");
        propID = "lib";
        String newLib = this.getNewPropValue(pageID, propID, "lib");
        propID = "libPath";
        String newLibSearchPath = this.getNewPropValue(pageID, propID, "c:/openmp/lib");
        propID = "OpenMPCompileCommand";
        String OpenMPCompileCommand = this.getNewPropValue(pageID, propID, "gcc");
        propID = "OpenMPLinkCommand";
        String OpenMPLinkCommand = this.getNewPropValue(pageID, propID, "gcccc");
        IManagedBuildInfo info = null;
        try {
            info = ManagedBuildManager.getBuildInfo((IResource)proj);
        }
        catch (Exception e) {
            System.out.println("OpenMPProjectProcess.run(), " + e.getMessage());
            e.printStackTrace();
            return;
        }
        assert (info != null);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration[] configs = mProj.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            IConfiguration cf = configs[i];
            this.addIncludePath(cf, newIncludePath);
            this.addLinkerOpt(cf, newLib, newLibSearchPath);
            this.setCompileCommand(cf, OpenMPCompileCommand);
            this.setLinkCommand(cf, OpenMPLinkCommand);
            ++i;
        }
        ManagedBuildManager.saveBuildInfo((IProject)proj, (boolean)true);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MpiWizardsPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    private String getNewPropValue(String pageID, String propID, String defaultVal) {
        String obj = this.valueStore.get(String.valueOf(pageID) + "." + propID);
        String newValue = defaultVal;
        if (obj != null) {
            newValue = obj.toString();
        }
        return newValue;
    }

    private void addIncludePath(IConfiguration cf, String newIncludePath) {
        String ext = "c";
        ITool cfTool = cf.getToolFromInputExtension(ext);
        String name = cfTool.getName();
        IOption option = null;
        option = name.startsWith("XL C") ? cfTool.getOptionById("xlc.c.compiler.option.include.paths") : this.getFirstOptionByType(cf, cfTool, 4);
        if (option != null) {
            String[] includePaths = null;
            try {
                includePaths = option.getIncludePaths();
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
            String[] newIncludePaths = this.add(includePaths, newIncludePath);
            ManagedBuildManager.setOption((IConfiguration)cf, (IHoldsOptions)cfTool, (IOption)option, (String[])newIncludePaths);
        } else {
            System.out.println("MPIProjectProcess, no option for include paths found.");
        }
    }

    private void addLinkerOpt(IConfiguration cf, String libName, String libPath) {
        String ext = "o";
        ITool cfTool = cf.getToolFromInputExtension(ext);
        IOption lpOpt = this.getFirstOptionByType(cf, cfTool, 9);
        this.addOptionValue(cf, cfTool, lpOpt, libPath);
        IOption libOpt = this.getFirstOptionByType(cf, cfTool, 6);
        this.addOptionValue(cf, cfTool, libOpt, libName);
    }

    private void setCompileCommand(IConfiguration cf, String buildCmd) {
        ITool compiler = cf.getToolFromInputExtension("c");
        compiler.setToolCommand(buildCmd);
    }

    private void setLinkCommand(IConfiguration cf, String buildCmd) {
        ITool linker = cf.getToolFromInputExtension("o");
        linker.setToolCommand(buildCmd);
    }

    private void addOptionValue(IConfiguration cf, ITool tool, IOption option, String value) {
        try {
            int type = option.getValueType();
            String[] valueList = null;
            switch (type) {
                case 4: {
                    valueList = option.getIncludePaths();
                    valueList = this.add(valueList, value);
                    break;
                }
                case 6: {
                    valueList = option.getLibraries();
                    valueList = this.addNotPath(valueList, value);
                    break;
                }
                case 9: {
                    valueList = option.getBasicStringListValue();
                    valueList = this.addNotPath(valueList, value);
                    break;
                }
                default: {
                    System.out.println("OpenMPProjectWizard Process postprocessing (OpenMPProjectProcess), can't get type of option for " + option.getName());
                    return;
                }
            }
            ManagedBuildManager.setOption((IConfiguration)cf, (IHoldsOptions)tool, (IOption)option, (String[])valueList);
        }
        catch (BuildException e) {
            System.out.println("OpenMPProjectProcess.addOptionValue(), " + e.getMessage());
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void showOptions(IManagedProject proj) {
        IConfiguration[] configs = proj.getConfigurations();
        try {
            int i = 0;
            while (i < configs.length) {
                IConfiguration cf = configs[i];
                ITool[] allTools = cf.getTools();
                int numTools = allTools.length;
                System.out.println("Config " + i + ": " + cf.getName() + " has " + numTools + " tools.");
                int k = 0;
                while (k < allTools.length) {
                    ITool tool = allTools[k];
                    System.out.println("  Tool " + k + ": " + tool.getName());
                    String toolCmd = tool.getToolCommand();
                    String toolID = tool.getId();
                    System.out.println("  cmd=" + toolCmd + "  toolID=" + toolID);
                    IOption[] options = tool.getOptions();
                    int j = 0;
                    while (j < options.length) {
                        IOption opt = options[j];
                        String foundOptionID = opt.getId();
                        int type = opt.getValueType();
                        System.out.println("    option " + j + " " + opt.getName() + " id=" + foundOptionID + "  type=" + this.showType(type));
                        if (opt.getValueType() == 4) {
                            this.showIncludePaths(opt);
                        }
                        ++j;
                    }
                    ++k;
                }
                System.out.println("Config " + i + ": " + cf.getName() + "======= End of ALL tools ");
                String ext = "c";
                ITool cfTool = cf.getToolFromInputExtension(ext);
                System.out.println("Tool by ext: " + ext + " is: " + cfTool.getName());
                IOption option = this.getFirstOptionByType(cf, cfTool, 4);
                if (option != null) {
                    String oname = option.getName();
                    System.out.println("Option " + option.getId() + " is " + oname);
                    this.showIncludePaths(option);
                } else {
                    System.out.println("No include path option found. ");
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String showType(int type) {
        if (type == 4) {
            return String.valueOf(type) + " (IOption.INCLUDE_PATH)";
        }
        if (type == 9) {
            return String.valueOf(type) + " (IOption.LIBRARY_PATHS)";
        }
        if (type == 6) {
            return String.valueOf(type) + " (IOption.LIBRARIES)";
        }
        return String.valueOf(type) + " ";
    }

    private void showIncludePaths(IOption opt) throws BuildException {
        assert (opt.getValueType() == 4);
        String[] includePaths = opt.getIncludePaths();
        int index = 0;
        while (index < includePaths.length) {
            String path = includePaths[index];
            System.out.println("   include path " + index + ": " + path);
            ++index;
        }
    }

    private String[] add(String[] existingPaths, String newPath) {
        String path;
        String pathSep = File.pathSeparator;
        ArrayList<String> newPathList = new ArrayList<String>();
        int i = 0;
        while (i < existingPaths.length) {
            path = existingPaths[i];
            newPathList.add(path);
            ++i;
        }
        String[] newPathArray = newPath.split(pathSep);
        int i2 = 0;
        while (i2 < newPathArray.length) {
            path = newPathArray[i2];
            newPathList.add(path);
            ++i2;
        }
        String[] newArray = newPathList.toArray(new String[0]);
        return newArray;
    }

    private String[] addNotPath(String[] strList, String newStr) {
        int len = strList.length;
        String[] newList = new String[len + 1];
        System.arraycopy(strList, 0, newList, 0, len);
        newList[len] = newStr;
        return newList;
    }

    private String unroll(String[] list) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < list.length) {
            String string = list[i];
            result.append(string);
            result.append(", ");
            ++i;
        }
        if (result.length() > 2) {
            result.delete(result.length() - 2, result.length() - 1);
        }
        return result.toString();
    }

    private List<IOption> getOptionsByType(IConfiguration cf, ITool cfTool, int optionType) {
        IOption[] allOptions = cfTool.getOptions();
        ArrayList<IOption> foundOptions = new ArrayList<IOption>();
        int i = 0;
        while (i < allOptions.length) {
            block4: {
                IOption option = allOptions[i];
                int oType = 0;
                try {
                    oType = option.getValueType();
                }
                catch (BuildException e) {
                    e.printStackTrace();
                    break block4;
                }
                if (optionType == oType) {
                    foundOptions.add(option);
                }
            }
            ++i;
        }
        return foundOptions;
    }

    private IOption getFirstOptionByType(IConfiguration cf, ITool cfTool, int optionType) {
        List<IOption> allOptions = this.getOptionsByType(cf, cfTool, optionType);
        if (allOptions.size() > 0) {
            return allOptions.get(0);
        }
        return null;
    }
}

