/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.aif;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFactory;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValue;
import org.eclipse.ptp.debug.core.pdi.model.aif.ITypeAggregate;
import org.eclipse.ptp.debug.core.pdi.model.aif.IValueAggregate;
import org.eclipse.ptp.debug.core.pdi.model.aif.IValueParent;
import org.eclipse.ptp.debug.internal.core.pdi.aif.ValueParent;

public abstract class ValueAggregate
extends ValueParent
implements IValueAggregate {
    protected List<IAIFValue> values = new ArrayList<IAIFValue>();

    public ValueAggregate(IValueParent parent, ITypeAggregate type, AIFFactory.SimpleByteBuffer buffer) {
        super(parent, type);
        this.parse(buffer);
    }

    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        ITypeAggregate typeAggregate = (ITypeAggregate)this.getType();
        int num_children = typeAggregate.getNumberOfChildren();
        int i = 0;
        while (i < num_children) {
            IAIFType aifType = typeAggregate.getType(i);
            IAIFValue val = AIFFactory.getAIFValue(this.getParent(), aifType, buffer);
            this.values.add(val);
            this.size += val.sizeof();
            ++i;
        }
    }

    public int getChildrenNumber() throws AIFException {
        return this.values.size();
    }

    public String getValueString() throws AIFException {
        if (this.result == null) {
            this.result = this.getString();
        }
        return this.result;
    }

    private String getString() throws AIFException {
        String content = "{";
        int length = this.values.size();
        int i = 0;
        while (i < length) {
            IAIFValue value = this.values.get(i);
            content = String.valueOf(content) + value.getValueString();
            if (i < length - 1) {
                content = String.valueOf(content) + ",";
            }
            ++i;
        }
        return String.valueOf(content) + "}";
    }

    public IAIFValue getValue(int index) {
        return this.values.get(index);
    }
}

