/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDILocator;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.PDILocationFactory;
import org.eclipse.ptp.debug.core.pdi.SessionObject;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIRegisterManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIVariableManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIGlobalVariable;
import org.eclipse.ptp.debug.core.pdi.model.IPDIGlobalVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDIInstruction;
import org.eclipse.ptp.debug.core.pdi.model.IPDIMixedInstruction;
import org.eclipse.ptp.debug.core.pdi.model.IPDIRegister;
import org.eclipse.ptp.debug.core.pdi.model.IPDIRegisterDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDIRegisterGroup;
import org.eclipse.ptp.debug.core.pdi.model.IPDIRuntimeOptions;
import org.eclipse.ptp.debug.core.pdi.model.IPDISharedLibrary;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrame;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrameDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariable;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.request.IPDIGetInfoThreadsRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDISetThreadSelectRequest;
import org.eclipse.ptp.debug.internal.core.pdi.model.RegisterDescriptor;
import org.eclipse.ptp.debug.internal.core.pdi.model.StackFrame;
import org.eclipse.ptp.debug.internal.core.pdi.model.Thread;

public class Target
extends SessionObject
implements IPDITarget {
    private Thread[] noThreads = new Thread[0];
    private Thread[] currentThreads;
    private int currentThreadId;
    private final ReentrantLock lock = new ReentrantLock();

    public Target(IPDISession session, BitList tasks) {
        super(session, tasks);
        this.currentThreads = this.noThreads;
    }

    public IPDIGlobalVariable createGlobalVariable(IPDIGlobalVariableDescriptor varDesc) throws PDIException {
        if (varDesc instanceof IPDIGlobalVariableDescriptor) {
            IPDIVariableManager varMgr = this.getSession().getVariableManager();
            return varMgr.createGlobalVariable(varDesc);
        }
        return null;
    }

    public IPDIRegister createRegister(IPDIRegisterDescriptor varDesc) throws PDIException {
        if (varDesc instanceof RegisterDescriptor) {
            return this.session.getRegisterManager().createRegister((RegisterDescriptor)varDesc);
        }
        return null;
    }

    public String evaluateExpressionToString(IPDIStackFrame context, String expr) throws PDIException {
        Target target = (Target)context.getTarget();
        Thread currentThread = target.getCurrentThread();
        IPDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.setCurrentThread(context.getThread(), false);
        ((Thread)context.getThread()).setCurrentStackFrame((StackFrame)context, false);
        try {
            IAIF aif = null;
            IPDIVariable var = this.session.getVariableManager().getVariableByName(this.tasks, expr);
            aif = var == null ? this.session.getExpressionManager().getExpressionValue(this.getTasks(), expr) : var.getAIF();
            if (aif != null) {
                String string = aif.getValue().toString();
                return string;
            }
            throw new PDIException(this.getTasks(), "Unknonw varibale: " + expr);
        }
        finally {
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
        }
    }

    public synchronized Thread getCurrentThread() throws PDIException {
        Thread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            Thread pthread = threads[i];
            if (pthread.getId() == this.currentThreadId) {
                return pthread;
            }
            ++i;
        }
        return null;
    }

    public IPDIGlobalVariableDescriptor getGlobalVariableDescriptors(String filename, String function, String name) throws PDIException {
        return this.session.getVariableManager().getGlobalVariableDescriptor(this.getTasks(), filename, function, name);
    }

    public IPDIInstruction[] getInstructions(BigInteger startAddress, BigInteger endAddress) throws PDIException {
        return this.session.getSourceManager().getInstructions(this.getTasks(), startAddress, endAddress);
    }

    public IPDIInstruction[] getInstructions(String filename, int linenum) throws PDIException {
        return this.session.getSourceManager().getInstructions(this.getTasks(), filename, linenum);
    }

    public IPDIInstruction[] getInstructions(String filename, int linenum, int lines) throws PDIException {
        return this.session.getSourceManager().getInstructions(this.getTasks(), filename, linenum, lines);
    }

    public IPDIMixedInstruction[] getMixedInstructions(BigInteger startAddress, BigInteger endAddress) throws PDIException {
        return this.session.getSourceManager().getMixedInstructions(this.getTasks(), startAddress, endAddress);
    }

    public IPDIMixedInstruction[] getMixedInstructions(String filename, int linenum) throws PDIException {
        return this.session.getSourceManager().getMixedInstructions(this.getTasks(), filename, linenum);
    }

    public IPDIMixedInstruction[] getMixedInstructions(String filename, int linenum, int lines) throws PDIException {
        return this.session.getSourceManager().getMixedInstructions(this.getTasks(), filename, linenum, lines);
    }

    public IPDIRegisterGroup[] getRegisterGroups() throws PDIException {
        return this.session.getRegisterManager().getRegisterGroups(this.getTasks());
    }

    public IPDIRuntimeOptions getRuntimeOptions() {
        return null;
    }

    public IPDISharedLibrary[] getSharedLibraries() throws PDIException {
        throw new PDIException(this.getTasks(), "Not implemented yet - Target: getSharedLibraries()");
    }

    public String[] getSourcePaths() throws PDIException {
        return this.session.getSourceManager().getSourcePaths(this.getTasks());
    }

    public synchronized Thread[] getThreads() throws PDIException {
        if (this.currentThreads.length == 0) {
            this.currentThreads = this.getPThreads();
        }
        return this.currentThreads;
    }

    public void lockTarget() {
        this.lock.lock();
    }

    public void releaseTarget() {
        this.lock.unlock();
    }

    public void setCurrentThread(IPDIThread pthread, boolean doUpdate) throws PDIException {
        if (pthread instanceof IPDIThread) {
            int id = pthread.getId();
            if (id == 0) {
                return;
            }
            if (this.currentThreadId != id) {
                IPDISetThreadSelectRequest request = this.session.getRequestFactory().getSetThreadSelectRequest(this.session, this.getTasks(), id);
                this.session.getEventRequestManager().addEventRequest(request);
                this.currentThreadId = request.getThreadId(this.getTasks());
                IPDIStackFrameDescriptor frame = request.getStackFrame(this.getTasks());
                if (frame != null) {
                    int depth = pthread.getStackFrameCount();
                    IPDILocator locator = PDILocationFactory.newLocator(frame.getLocator().getFile(), frame.getLocator().getFunction(), frame.getLocator().getLineNumber(), frame.getLocator().getAddress());
                    pthread.setCurrentStackFrame(this.session.getModelFactory().newStackFrame(this.session, pthread, depth - frame.getLevel(), locator));
                }
                if (doUpdate) {
                    IPDIVariableManager varMgr;
                    IPDIRegisterManager regMgr = this.session.getRegisterManager();
                    if (regMgr.isAutoUpdate()) {
                        regMgr.update(this.getTasks());
                    }
                    if ((varMgr = this.session.getVariableManager()).isAutoUpdate()) {
                        varMgr.update(this.getTasks());
                    }
                }
            }
            if (this.currentThreadId != id) {
                this.session.getEventManager().fireEvents(new IPDIEvent[]{this.session.getEventFactory().newDestroyedEvent(this.session.getEventFactory().newThreadInfo(this.session, this.getTasks(), id, this.getThread(id)))});
                throw new PDIException(this.getTasks(), "Target - Cannot switch to thread " + id);
            }
        } else {
            throw new PDIException(this.getTasks(), "Target - Unknown_thread");
        }
    }

    public void setSourcePaths(String[] srcPaths) throws PDIException {
        this.session.getSourceManager().setSourcePaths(this.getTasks(), srcPaths);
    }

    public synchronized void setSupended(boolean state) {
        this.notifyAll();
    }

    public synchronized void updateState(int newThreadId) {
        int j;
        Thread[] oldThreads = this.currentThreads;
        this.lockTarget();
        this.currentThreadId = newThreadId;
        try {
            this.currentThreads = this.getPThreads();
        }
        catch (PDIException pDIException) {
            this.currentThreads = this.noThreads;
        }
        this.releaseTarget();
        ArrayList<Integer> pList = new ArrayList<Integer>(this.currentThreads.length);
        int i = 0;
        while (i < this.currentThreads.length) {
            boolean found = false;
            j = 0;
            while (j < oldThreads.length) {
                if (this.currentThreads[i].getId() == oldThreads[j].getId()) {
                    oldThreads[j].clearState();
                    this.currentThreads[i] = oldThreads[j];
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                pList.add(new Integer(this.currentThreads[i].getId()));
            }
            ++i;
        }
        if (!pList.isEmpty()) {
            IPDIEvent[] events = new IPDIEvent[pList.size()];
            int j2 = 0;
            while (j2 < events.length) {
                int id = (Integer)pList.get(j2);
                events[j2] = this.session.getEventFactory().newCreatedEvent(this.session.getEventFactory().newThreadInfo(this.session, this.getTasks(), id, this.getThread(id)));
                ++j2;
            }
            this.session.getEventManager().fireEvents(events);
        }
        ArrayList<Integer> dList = new ArrayList<Integer>(oldThreads.length);
        int i2 = 0;
        while (i2 < oldThreads.length) {
            boolean found = false;
            int j3 = 0;
            while (j3 < this.currentThreads.length) {
                if (this.currentThreads[j3].getId() == oldThreads[i2].getId()) {
                    found = true;
                    break;
                }
                ++j3;
            }
            if (!found) {
                dList.add(new Integer(oldThreads[i2].getId()));
            }
            ++i2;
        }
        if (!dList.isEmpty()) {
            IPDIEvent[] events = new IPDIEvent[dList.size()];
            j = 0;
            while (j < events.length) {
                int id = (Integer)dList.get(j);
                events[j] = this.session.getEventFactory().newDestroyedEvent(this.session.getEventFactory().newThreadInfo(this.session, this.getTasks(), id, this.getThread(id)));
                ++j;
            }
            this.session.getEventManager().fireEvents(events);
        }
    }

    private synchronized Thread[] getPThreads() throws PDIException {
        Thread[] pthreads = this.noThreads;
        this.lockTarget();
        try {
            IPDIGetInfoThreadsRequest request = this.session.getRequestFactory().getGetInfoThreadsRequest(this.getTasks());
            this.session.getEventRequestManager().addEventRequest(request);
            String[] ids = request.getThreadIds(this.getTasks());
            if (ids.length > 0) {
                pthreads = new Thread[ids.length];
                int i = 0;
                while (i < ids.length) {
                    int tid = 0;
                    try {
                        tid = Integer.parseInt(ids[i]);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    pthreads[i] = new Thread(this.session, this, tid);
                    ++i;
                }
            } else {
                pthreads = new Thread[]{new Thread(this.session, this, 0)};
            }
            this.currentThreadId = pthreads[0].getId();
            if (this.currentThreadId == 0 && pthreads.length > 1) {
                this.currentThreadId = pthreads[1].getId();
            }
        }
        finally {
            this.releaseTarget();
        }
        return pthreads;
    }

    private Thread getThread(int tid) {
        Thread th = null;
        if (this.currentThreads != null) {
            int i = 0;
            while (i < this.currentThreads.length) {
                Thread pthread = this.currentThreads[i];
                if (pthread.getId() == tid) {
                    th = pthread;
                    break;
                }
                ++i;
            }
        }
        return th;
    }
}

