/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.debug.be.preferences;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.debug.be.debug.Debug;
import org.eclipse.ptp.cell.debug.be.preferences.BEDebugPreferencesDefaults;
import org.eclipse.ptp.cell.debug.be.ui.preferences.CellDebugBEPreferencesMessages;
import org.eclipse.ptp.cell.preferences.core.SearcherMessages;
import org.eclipse.ptp.cell.preferences.core.StringFieldEditorPreferenceSearcher;
import org.eclipse.ptp.cell.utils.linux.findutils.Find;
import org.eclipse.ptp.cell.utils.linux.which.Which;
import org.eclipse.ptp.cell.utils.searcher.SearchFailedException;
import org.eclipse.swt.widgets.Composite;

public class GdbClientSearcher
extends StringFieldEditorPreferenceSearcher {
    protected static final String GDB_CLIENT_EXECUTABLE = BEDebugPreferencesDefaults.getString("gdbClientExecutable");
    protected static final String GDB_PACKAGE_NAME = BEDebugPreferencesDefaults.getString("gdbPackageName");
    protected static final String GDB_SEARCH_ROOT_DIRECTORY = BEDebugPreferencesDefaults.getString("gdbSearchRootDirectory");

    public GdbClientSearcher(StringFieldEditor stringFieldEditor, Composite parent) {
        super(stringFieldEditor, parent);
    }

    protected void fastSearch() throws SearchFailedException {
        String gdbClient;
        String currentPreferenceValue = this.stringFieldEditor.getStringValue();
        if (this.isValidGdbClient(currentPreferenceValue)) {
            Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Current value is valid");
            return;
        }
        String defaultPreferenceValue = this.preferenceStore.getDefaultString(this.preferenceName);
        if (!currentPreferenceValue.equals(defaultPreferenceValue) && this.isValidGdbClient(defaultPreferenceValue)) {
            Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Default value is valid");
            this.setText(defaultPreferenceValue);
            return;
        }
        if (Platform.getOS().equals("linux") && this.isValidGdbClient(gdbClient = Which.which((String)GDB_CLIENT_EXECUTABLE))) {
            Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Value returned from 'which' is valid");
            this.setText(gdbClient);
            return;
        }
        Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "All fast searches failed,");
        throw new SearchFailedException(SearcherMessages.fastSearchFailedMessage);
    }

    protected void longSearch() {
        new Thread(){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Start long searcher for GNU tools. Start 'find'.");
                    if (!Platform.getOS().equals("linux")) ** GOTO lbl15
                    gdbClient = Find.findFile((String)GdbClientSearcher.GDB_SEARCH_ROOT_DIRECTORY, (String)GdbClientSearcher.GDB_CLIENT_EXECUTABLE);
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "'find' finished.");
                    if (GdbClientSearcher.this.isValidGdbClient(gdbClient)) {
                        GdbClientSearcher.access$0(GdbClientSearcher.this, gdbClient);
                        Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Long searcher successfull.");
                        GdbClientSearcher.access$1(GdbClientSearcher.this, SearcherMessages.searchSucceededDialogTitle, NLS.bind((String)SearcherMessages.searchSucceededDialogMessage, (Object)CellDebugBEPreferencesMessages.getString("CellDebugBEPreferencePage.0")));
                        return;
                    }
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Long searcher found nothing.");
                    GdbClientSearcher.access$1(GdbClientSearcher.this, SearcherMessages.searchFailedDialogTitle, NLS.bind((String)SearcherMessages.searchFailedDialogMessage, (Object)CellDebugBEPreferencesMessages.getString("CellDebugBEPreferencePage.0")));
                    return;
lbl15:
                    // 1 sources

                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Not a Linux platform, no long search is available.");
                    return;
                }
                catch (Exception e) {
                    Debug.POLICY.error(Debug.DEBUG_SEARCHER, (Throwable)e);
                    Debug.POLICY.logError((Throwable)e);
                    return;
                }
                finally {
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Finished long searcher for GDB tools.");
                }
            }
        }.start();
    }

    protected boolean isValidGdbClient(String gdbClientPath) {
        File gdbClient;
        return gdbClientPath != null && (gdbClient = new File(gdbClientPath)).exists() && gdbClient.isFile();
    }

    static /* synthetic */ void access$0(GdbClientSearcher gdbClientSearcher, String string) {
        gdbClientSearcher.setText(string);
    }

    static /* synthetic */ void access$1(GdbClientSearcher gdbClientSearcher, String string, String string2) {
        gdbClientSearcher.showInfoMessage(string, string2);
    }
}

