/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.core.common;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.environment.cellsimulator.CellSimulatorTargetPlugin;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.Messages;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.StopResumeLogic;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.TargetConfig;
import org.eclipse.ptp.cell.simulator.SimulatorPlugin;
import org.eclipse.ptp.cell.simulator.core.ISimulatorControl;
import org.eclipse.ptp.cell.simulator.core.ISimulatorListener;
import org.eclipse.ptp.cell.simulator.core.ISimulatorParameters;
import org.eclipse.ptp.cell.simulator.core.IllegalConfigurationException;
import org.eclipse.ptp.cell.simulator.core.SimulatorException;
import org.eclipse.ptp.cell.simulator.core.SimulatorKilledException;
import org.eclipse.ptp.cell.simulator.core.SimulatorOperationException;
import org.eclipse.ptp.cell.simulator.core.SimulatorTerminatedException;
import org.eclipse.ptp.cell.ui.console.TerminalToConsoleBridge;
import org.eclipse.ptp.cell.ui.progress.ProgressQueue;
import org.eclipse.ptp.remotetools.RemotetoolsPlugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.SSHTargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;

public abstract class AbstractTargetControl
extends SSHTargetControl
implements ITargetControl {
    protected static final int SIMULATOR_SHIFT = 1000;
    protected static final int SIMULATOR_EVENT = 4000;
    protected static final int DEPLOY_EVENT = 2000;
    protected static final int CONNECT_EVENT = 3000;
    public static final String DEFAULT_SIMULATOR_CIPHER = RemotetoolsPlugin.CIPHER_BLOWFISH;
    protected IOConsole linuxConsole;
    protected TerminalToConsoleBridge linuxBridge;
    protected IOConsole tclConsole;
    protected TerminalToConsoleBridge tclBridge;
    protected TargetConfig currentTargetConfig;
    protected ISimulatorControl simulatorControl = SimulatorPlugin.getDefault().createSimulatorControl();
    protected StopResumeLogic stopResumeLogic;
    protected ITargetElement targetElement;

    public AbstractTargetControl(ITargetElement element) throws CoreException {
        this.targetElement = element;
    }

    public String getName() {
        return this.targetElement.getName();
    }

    protected String getPluginId() {
        return CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName();
    }

    protected void setCurrentTargetConfig(TargetConfig currentTargetConfig) {
        this.currentTargetConfig = currentTargetConfig;
    }

    protected TargetConfig getCurrentTargetConfig() {
        return this.currentTargetConfig;
    }

    protected void populateProgressQueueWithSimulatorLaunch(ProgressQueue queue) {
        queue.addWait(4000, Messages.AbstractTargetControl_PreparingSimulatorPlugin, 1);
        queue.addWait(2000, Messages.AbstractTargetControl_PreparingToDeploy, 1);
        queue.addWait(1200, Messages.AbstractTargetControl_StartingSimulator, 1);
        queue.addWait(1300, Messages.AbstractTargetControl_ParsingLaunchScript, 1);
        queue.addWait(1301, Messages.AbstractTargetControl_ValidatingParameters, 1);
        queue.addWait(1302, Messages.AbstractTargetControl_CreatingMachine, 1);
        queue.addWait(1303, Messages.AbstractTargetControl_StartingVirtualNetwork, 1);
        queue.addWait(1304, Messages.AbstractTargetControl_ConnectingLinuxConsole, 1);
        queue.addWait(1305, Messages.AbstractTargetControl_SimulatorReadyToBoot, 1);
        queue.addWait(1400, Messages.AbstractTargetControl_BootingBIOS, 5);
        queue.addWait(1401, Messages.AbstractTargetControl_LoadingKernel, 10);
        queue.addWait(1402, Messages.AbstractTargetControl_LoadingOS, 30);
        queue.addWait(1403, Messages.AbstractTargetControl_ConfiguringOS, 10);
    }

    protected void populateProgressQueueWithSimulatorShutdown(ProgressQueue queue) {
        queue.addWait(1022, Messages.AbstractTargetControl_KillingSystemProcesses, 1);
        queue.addWait(1023, Messages.AbstractTargetControl_CleaningUp, 1);
    }

    protected void populateProgressQueueWithConnection(ProgressQueue queue) {
        queue.addWait(3000, Messages.AbstractTargetControl_ConnectingThroughSSH, 1);
    }

    protected void launchSimulator(ProgressQueue progressQueue, ISimulatorParameters parameters) throws CoreException {
        block15: {
            try {
                progressQueue.notifyOperationStarted(4000);
                SimulatorLaunchListener listener = new SimulatorLaunchListener(progressQueue);
                try {
                    try {
                        this.simulatorControl.addListener((ISimulatorListener)listener);
                        try {
                            this.simulatorControl.launch(parameters);
                        }
                        catch (SimulatorOperationException e) {
                            if (e.getReason() == 4) {
                                class Asker
                                implements Runnable {
                                    boolean yes_no = false;

                                    Asker() {
                                    }

                                    public void run() {
                                        this.yes_no = MessageDialog.openQuestion(null, (String)Messages.AbstractTargetControl_SimulatorRunningQuestion, (String)Messages.AbstractTargetControl_ProblemWithSimulator);
                                    }
                                }
                                Asker asker = new Asker();
                                Display c = Display.getDefault();
                                c.syncExec((Runnable)asker);
                                if (asker.yes_no) {
                                    this.simulatorControl.clear();
                                    this.simulatorControl.launch(parameters);
                                    break block15;
                                }
                                throw e;
                            }
                            throw e;
                        }
                    }
                    catch (IllegalConfigurationException e) {
                        Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, NLS.bind((String)Messages.AbstractTargetControl_InvalidParameter, (Object)e.getMessage()), (Throwable)e);
                        throw new CoreException((IStatus)status);
                    }
                    catch (SimulatorTerminatedException e) {
                        Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, NLS.bind((String)Messages.AbstractTargetControl_ProblemLaunchingSimulator, (Object)e.getMessage()), (Throwable)e);
                        throw new CoreException((IStatus)status);
                    }
                    catch (SimulatorKilledException e) {
                        Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, NLS.bind((String)Messages.AbstractTargetControl_SimulatorCanceled, (Object)e.getMessage()), (Throwable)e);
                        throw new CoreException((IStatus)status);
                    }
                    catch (SimulatorException e) {
                        Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, NLS.bind((String)Messages.AbstractTargetControl_SimulatorLaunchFailed, (Object)e.getMessage()), (Throwable)e);
                        throw new CoreException((IStatus)status);
                    }
                    catch (Exception e) {
                        Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, NLS.bind((String)Messages.AbstractTargetControl_UnhandledException, (Object)e.getMessage()), (Throwable)e);
                        throw new CoreException((IStatus)status);
                    }
                }
                finally {
                    this.simulatorControl.removeListener((ISimulatorListener)listener);
                }
            }
            catch (CoreException e) {
                this.simulatorControl.kill();
                throw e;
            }
        }
    }

    protected void releaseSimulator() {
        this.simulatorControl.kill();
    }

    protected void kindlyReleaseSimulator(ProgressQueue progressQueue) throws CoreException {
        if (!this.simulatorControl.getStatus().isOperational()) {
            this.simulatorControl.kill();
        }
        SimulatorshutdownListener listener = new SimulatorshutdownListener(progressQueue);
        try {
            try {
                this.simulatorControl.addListener((ISimulatorListener)listener);
                this.simulatorControl.shutdown();
            }
            catch (SimulatorException e) {
                throw new CoreException((IStatus)new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.AbstractTargetControl_SimulatorShutDownError, (Throwable)e));
            }
        }
        finally {
            this.simulatorControl.removeListener((ISimulatorListener)listener);
        }
    }

    protected synchronized void launchResumePauseStrategy(ProgressQueue progressQueue) throws CoreException {
        try {
            this.simulatorControl.pause();
        }
        catch (SimulatorException e) {
            Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.AbstractTargetControl_SimulatorPauseFailed, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        this.stopResumeLogic = new StopResumeLogic(this.simulatorControl, this);
        this.stopResumeLogic.activate();
    }

    protected synchronized void releaseResumePauseStrategy() {
        if (this.stopResumeLogic != null) {
            this.stopResumeLogic.deactivate();
            this.stopResumeLogic = null;
        }
    }

    public boolean resume(IProgressMonitor monitor) throws CoreException {
        if (this.query() != 2) {
            if (this.query() == 3) {
                try {
                    this.simulatorControl.resume();
                }
                catch (SimulatorException e) {
                    Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.AbstractTargetControl_SimulatorResumeFailed, (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            } else {
                Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.AbstractTargetControl_CannotResumeSimulator, null);
                throw new CoreException((IStatus)status);
            }
        }
        return true;
    }

    public boolean stop(IProgressMonitor monitor) throws CoreException {
        if (this.query() == 2) {
            try {
                this.simulatorControl.pause();
            }
            catch (SimulatorException e) {
                Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.AbstractTargetControl_SimulatorPauseFailed, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        } else if (this.query() != 3) {
            Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.AbstractTargetControl_CannotResumeSimulator, null);
            throw new CoreException((IStatus)status);
        }
        return true;
    }

    protected void resetConsoles() {
        if (this.linuxConsole != null) {
            this.linuxConsole.clearConsole();
        }
        if (this.tclConsole != null) {
            this.tclConsole.clearConsole();
        }
        if (this.currentTargetConfig.isConsoleShowLinux()) {
            if (this.linuxConsole != null) {
                IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
                consoleManager.showConsoleView((IConsole)this.linuxConsole);
            }
        } else if (this.currentTargetConfig.isConsoleShowSimulator() && this.tclConsole != null) {
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            consoleManager.showConsoleView((IConsole)this.tclConsole);
        }
    }

    protected void updateConsoles() {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        if (this.currentTargetConfig != null) {
            if (this.linuxConsole == null && this.currentTargetConfig.isConsoleShowLinux()) {
                this.linuxConsole = new IOConsole(String.valueOf(Messages.AbstractTargetControl_LinuxConsoleMessage) + this.getName(), null);
                this.linuxBridge = new TerminalToConsoleBridge(this.simulatorControl.getLinuxTerminal(), this.linuxConsole, Messages.AbstractTargetControl_LinuxConsole);
                consoleManager.addConsoles(new IConsole[]{this.linuxConsole});
            }
            if (this.tclConsole == null && this.currentTargetConfig.isConsoleShowSimulator()) {
                this.tclConsole = new IOConsole(String.valueOf(Messages.AbstractTargetControl_TCLConsoleMessage) + this.getName(), null);
                this.tclBridge = new TerminalToConsoleBridge(this.simulatorControl.getProcessTerminal(), this.tclConsole, Messages.AbstractTargetControl_ProcessConsole);
                consoleManager.addConsoles(new IConsole[]{this.tclConsole});
            }
            if (this.linuxConsole != null && !this.currentTargetConfig.isConsoleShowLinux()) {
                consoleManager.removeConsoles(new IConsole[]{this.linuxConsole});
                this.linuxBridge.disconnect();
                this.linuxBridge = null;
                this.linuxConsole = null;
            }
            if (this.tclConsole != null && !this.currentTargetConfig.isConsoleShowSimulator()) {
                consoleManager.removeConsoles(new IConsole[]{this.tclConsole});
                this.tclBridge.disconnect();
                this.tclBridge = null;
                this.tclConsole = null;
            }
        }
    }

    protected void connectSimulator(IProgressMonitor monitor, ProgressQueue progressQueue) throws CoreException {
        try {
            progressQueue.notifyOperationStarted(3000);
            this.disconnect();
            while (true) {
                if (!this.simulatorControl.getStatus().isOperational()) {
                    this.disconnect();
                    throw new CoreException((IStatus)new Status(4, this.getPluginId(), 0, Messages.AbstractTargetControl_SimulatorExited, null));
                }
                if (progressQueue.isCancelled()) {
                    throw new CoreException((IStatus)new Status(8, this.getPluginId(), 0, Messages.AbstractTargetControl_ConnectionCanceled, null));
                }
                try {
                    this.connect();
                }
                catch (RemoteConnectionException e) {
                    monitor.subTask(NLS.bind((String)Messages.AbstractTargetControl_Failed, (Object)e.getMessage()));
                    this.disconnect();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new CoreException((IStatus)new Status(8, this.getPluginId(), 0, Messages.AbstractTargetControl_ConnectionCanceled, null));
                    }
                    monitor.subTask(Messages.AbstractTargetControl_TryingAgain);
                    continue;
                }
                break;
            }
            progressQueue.notifyOperationCompleted(3000);
        }
        catch (CoreException e) {
            this.disconnect();
            throw e;
        }
        catch (Exception e) {
            this.disconnect();
            throw new CoreException((IStatus)new Status(8, this.getPluginId(), 0, Messages.AbstractTargetControl_ConnectionFailed, (Throwable)e));
        }
    }

    protected class SimulatorLaunchListener
    implements ISimulatorListener {
        ProgressQueue queue;

        public SimulatorLaunchListener(ProgressQueue queue) {
            this.queue = queue;
        }

        public void lifecycleStateChanged(int state) {
            if (state == 14) {
                this.queue.notifyOperationStarted(2000);
            }
        }

        public void progressChanged(int progress) {
            this.queue.notifyOperationStarted(1000 + progress);
        }

        public void simulationStatus(int status) {
        }
    }

    protected class SimulatorshutdownListener
    implements ISimulatorListener {
        ProgressQueue queue;
        boolean finished = false;

        public SimulatorshutdownListener(ProgressQueue queue) {
            this.queue = queue;
        }

        public synchronized void lifecycleStateChanged(int state) {
            if (state == 13 && !this.finished) {
                this.queue.notifyOperationCompleted(1023);
                this.finished = true;
            }
        }

        public synchronized void progressChanged(int progress) {
            if (progress == 23) {
                this.finished = true;
            }
            this.queue.notifyOperationStarted(1000 + progress);
        }

        public void simulationStatus(int status) {
        }
    }
}

