/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.core.common;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.cell.environment.cellsimulator.CellSimulatorTargetPlugin;
import org.eclipse.ptp.cell.environment.cellsimulator.conf.AttributeNames;
import org.eclipse.ptp.cell.environment.cellsimulator.conf.Parameters;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.CommonConfigurationBean;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.Messages;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.TargetConfig;
import org.eclipse.ptp.cell.simulator.SimulatorPlugin;
import org.eclipse.ptp.cell.simulator.core.AbstractSimulatorConfiguration;
import org.eclipse.ptp.cell.simulator.core.ISimulatorParameters;
import org.eclipse.ptp.cell.simulator.extensions.Architecture;
import org.eclipse.ptp.cell.simulator.extensions.LaunchProfile;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;
import org.eclipse.ptp.remotetools.utils.verification.IllegalAttributeException;

public abstract class CommonConfigFactory {
    CommonConfigurationBean bean;

    public CommonConfigFactory(CommonConfigurationBean bean) {
        this.bean = bean;
    }

    protected void fillSimulatorParameters(AbstractSimulatorConfiguration parameters) throws CoreException {
        ControlAttributes attributes = this.bean.getAttributes();
        try {
            String persistence;
            LaunchProfile profile;
            Architecture architecture;
            parameters.setSimulatorBaseDirectory(attributes.getString("simulator-base-directory", null));
            String architectureId = attributes.getString("architecture-id", null);
            if (architectureId != null && (architecture = SimulatorPlugin.getArchitectureManager().getArchitecture(architectureId)) != null) {
                try {
                    parameters.setArchitectureTclString(architecture.getTclScriptContent());
                }
                catch (IOException e) {
                    throw new IllegalAttributeException(Messages.CommonConfigFactory_ReadTCLScriptFailed, (Throwable)e);
                }
            }
            parameters.setMemorySize(attributes.verifyInt(Messages.CommonConfigFactory_MemorySize, "memory-size"));
            String profileId = attributes.getString("profile-id", null);
            if (profileId != null && (profile = SimulatorPlugin.getLaunchProfileManager().getLaunchProfile(profileId)) != null) {
                parameters.setDeployFileNames(profile.getDeployPaths());
                parameters.setDeployFileSources(profile.getDeployURLs());
                parameters.setTclScriptName(profile.getTclScriptPath());
                parameters.setTclScriptSource(profile.getTclScriptURL());
            }
            parameters.setExtraCommandLineSwitches(attributes.getString("extra-command-line-switches", null));
            parameters.setNetworkInit(true);
            parameters.setSshInit(true);
            if (attributes.getBoolean("extra-image-init", false)) {
                parameters.setExtraImagePath(attributes.getString("extra-image-path", null));
                persistence = attributes.verifyString(AttributeNames.ROOT_IMAGE_PERSISTENCE, "extra-image-persistence");
                if (persistence.equals("discard")) {
                    parameters.setExtraImagePersistence(1);
                } else if (persistence.equals("journal")) {
                    parameters.setExtraImagePersistence(3);
                } else if (persistence.equals("write")) {
                    parameters.setExtraImagePersistence(2);
                } else {
                    throw new IllegalAttributeException(AttributeNames.ROOT_IMAGE_PERSISTENCE, Messages.CommonConfigFactory_InvalidPersistenceID);
                }
                parameters.setExtraImageJournalPath(attributes.getString("extra-image-journal-path", null));
                parameters.setExtraImageType(attributes.getString("extra-image-type", null));
                parameters.setExtraImageMountPoint(attributes.getString("extra-image-mountpoint", null));
            }
            parameters.setKernelImagePath(attributes.getString("kernel-image-path", null));
            parameters.setRootImagePath(attributes.getString("root-image-path", null));
            persistence = attributes.verifyString(AttributeNames.EXTRA_IMAGE_PERSISTENCE, "root-image-persistence");
            if (persistence.equals("discard")) {
                parameters.setRootImagePersistence(1);
            } else if (persistence.equals("journal")) {
                parameters.setRootImagePersistence(3);
            } else if (persistence.equals("write")) {
                parameters.setRootImagePersistence(2);
            } else {
                throw new IllegalAttributeException("root-image-persistence", Messages.CommonConfigFactory_InvalidPersistenceID);
            }
            parameters.setRootImageJournalPath(attributes.getString("root-image-journal-path", null));
            parameters.setConsoleCommands(attributes.getString("customization-script", null));
        }
        catch (IllegalAttributeException e) {
            throw new CoreException((IStatus)new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
        }
    }

    public TargetConfig createTargetConfig() throws CoreException {
        ControlAttributes attributes = this.bean.getAttributes();
        try {
            TargetConfig config = new TargetConfig();
            if (attributes.getBoolean("automatic-authentication", true)) {
                config.setLoginUserName(Parameters.AUTOMATIC_USERNAME);
                config.setLoginPassword(Parameters.AUTOMATIC_PASSWORD);
            } else {
                config.setLoginUserName(attributes.verifyString(AttributeNames.USERNAME, "username"));
                config.setLoginPassword(attributes.getString("password", ""));
            }
            config.setLoginTimeout(attributes.verifyInt(AttributeNames.TIMEOUT, "timeout"));
            if (attributes.getString("simulator-cipher-type").equals("")) {
                throw new IllegalAttributeException(Messages.CommonConfigFactory_CannotBeEmpty, AttributeNames.CIPHER_TYPE);
            }
            config.setSimulatorCipherType(attributes.getString("simulator-cipher-type"));
            config.setLoginPort(Integer.parseInt(Parameters.LOGIN_PORT));
            config.setConsoleShowLinux(attributes.getBoolean("console-show-linux", true));
            config.setConsoleShowSimulator(attributes.getBoolean("console-show-simulator", false));
            config.setDoAutomaticNetworkConfiguration(attributes.getBoolean("automatic-network", false));
            config.setDoAutomaticPortConfiguration(attributes.getBoolean("automatic-portconfig", false));
            config.setSystemWorkspace(attributes.getString("system-workspace-dir"));
            return config;
        }
        catch (IllegalAttributeException e) {
            throw new CoreException((IStatus)new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
        }
    }

    public abstract ISimulatorParameters createSimulatorParameters() throws CoreException;
}

