/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.pdt.xml.wizard.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroup;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroupForest;
import org.eclipse.ptp.cell.pdt.xml.debug.Debug;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.Messages;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.table.TableContentProvider;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.table.TableLabelProvider;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.table.TableModifier;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PdtWizardGroupsPositionAndColorPage
extends WizardPage {
    protected EventGroupForest eventGroupForest;
    protected Table positionAndColorTable;
    protected TableViewer posAndColorTableViewer;
    protected Button selectColorButton;

    public PdtWizardGroupsPositionAndColorPage(EventGroupForest eventGroupForest) {
        super(PdtWizardGroupsPositionAndColorPage.class.getName());
        this.setTitle(Messages.PdtWizardGroupsPositionAndColorPage_Title);
        this.setDescription(Messages.PdtWizardGroupsPositionAndColorPage_Description);
        this.eventGroupForest = eventGroupForest;
    }

    public boolean isPageComplete() {
        boolean pageComplete = super.isPageComplete();
        return pageComplete &= this.isCurrentPage();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setFont(font);
        this.createTable(composite);
        this.selectColorButton = new Button(composite, 8);
        GridData buttonGridData = new GridData(131072, 1024, false, false, 1, 1);
        this.selectColorButton.setLayoutData((Object)buttonGridData);
        this.selectColorButton.setText(Messages.PdtWizardGroupsPositionAndColorPage_Button_SelectColor);
        this.selectColorButton.addSelectionListener((SelectionListener)new ButtonSelectionHandler());
        this.posAndColorTableViewer = this.createTableViewer();
        this.posAndColorTableViewer.setInput((Object)this.eventGroupForest);
        this.setControl((Control)composite);
    }

    private TableViewer createTableViewer() {
        TableViewer tableViewer = new TableViewer(this.positionAndColorTable);
        tableViewer.setUseHashlookup(true);
        tableViewer.setColumnProperties(Column.getColumnsAssociatedNames());
        CellEditor[] editors = new CellEditor[Column.values().length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this.positionAndColorTable);
        editors[Column.NAME.ordinal()] = textEditor;
        textEditor = new TextCellEditor((Composite)this.positionAndColorTable);
        editors[Column.YSTART.ordinal()] = textEditor;
        textEditor = new TextCellEditor((Composite)this.positionAndColorTable);
        editors[Column.YEND.ordinal()] = textEditor;
        textEditor = new TextCellEditor((Composite)this.positionAndColorTable);
        editors[Column.COLOR.ordinal()] = textEditor;
        tableViewer.setCellEditors(editors);
        tableViewer.setCellModifier((ICellModifier)new TableModifier(tableViewer, this));
        tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        return tableViewer;
    }

    private void createTable(Composite composite) {
        this.positionAndColorTable = new Table(composite, 2048);
        this.positionAndColorTable.setHeaderVisible(true);
        this.positionAndColorTable.setLinesVisible(true);
        GridData tableData = new GridData(4, 4, true, true, 1, 1);
        this.positionAndColorTable.setLayoutData((Object)tableData);
        TableColumn name = new TableColumn(this.positionAndColorTable, 16384);
        name.setWidth(200);
        name.setText(Messages.PdtWizardGroupsPositionAndColorPage_CreateTable_ColumnHeader_EventGroup_Name);
        TableColumn yStart = new TableColumn(this.positionAndColorTable, 16384);
        yStart.setWidth(100);
        yStart.setText(Messages.PdtWizardGroupsPositionAndColorPage_CreateTable_ColumnHeader_EventGroup_Start);
        TableColumn yEnd = new TableColumn(this.positionAndColorTable, 16384);
        yEnd.setWidth(100);
        yEnd.setText(Messages.PdtWizardGroupsPositionAndColorPage_CreateTable_ColumnHeader_EventGroup_End);
        TableColumn color = new TableColumn(this.positionAndColorTable, 16384);
        color.setWidth(200);
        color.setText(Messages.PdtWizardGroupsPositionAndColorPage_CreateTable_ColumnHeader_EventGroup_Color);
    }

    public EventGroupForest getEventGroupForest() {
        return this.eventGroupForest;
    }

    public void displayErrorDialog(IStatus status) {
        Shell sh = this.getShell();
        ErrorDialog errdlg = new ErrorDialog(sh, Messages.PdtWizardGroupsPositionAndColorPage_DisplayErrorDialog_TableInputError, "", status, 4);
        errdlg.open();
    }

    public void selectColor() {
        IStructuredSelection sel = (IStructuredSelection)this.posAndColorTableViewer.getSelection();
        if (!sel.isEmpty()) {
            EventGroup selEventGroup = (EventGroup)sel.getFirstElement();
            ColorDialog selColorDialog = new ColorDialog(this.getShell());
            selColorDialog.setText(NLS.bind((String)Messages.PdtWizardGroupsPositionAndColorPage_SelectColor_Dialog_Message, (Object)selEventGroup.getName()));
            selColorDialog.open();
            RGB selColor = selColorDialog.getRGB();
            selEventGroup.setColor((selColor.red << 16) + (selColor.green << 8) + selColor.blue);
            this.posAndColorTableViewer.update((Object)selEventGroup, null);
        }
    }

    public void refresh() {
        this.posAndColorTableViewer.refresh();
    }

    protected class ButtonSelectionHandler
    extends SelectionAdapter {
        protected ButtonSelectionHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            Debug.read();
            try {
                PdtWizardGroupsPositionAndColorPage.this.selectColor();
            }
            catch (Exception exception) {
                Debug.POLICY.logError((Throwable)exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Column {
        NAME,
        YSTART,
        YEND,
        COLOR;


        public String getAssociatedName() {
            switch (this) {
                case NAME: {
                    return "name";
                }
                case YSTART: {
                    return "yStart";
                }
                case YEND: {
                    return "yEnd";
                }
                case COLOR: {
                    return "color";
                }
            }
            throw new AssertionError((Object)("Unknown op: " + (Object)((Object)this)));
        }

        public static String[] getColumnsAssociatedNames() {
            return new String[]{NAME.getAssociatedName(), YSTART.getAssociatedName(), YEND.getAssociatedName(), COLOR.getAssociatedName()};
        }
    }
}

