/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.managedbuilder.xlc.ui.scannerdiscovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.managedbuilder.xlc.ui.XLCUIPlugin;
import org.eclipse.cdt.utils.FileSystemUtilityManager;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.core.remotemake.RemoteSpecsRunSIProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteXLCSpecsRunSIProvider
extends RemoteSpecsRunSIProvider
implements IExternalScannerInfoProvider {
    protected List<String> getCommand(IProject project, String providerId, IScannerConfigBuilderInfo2 buildInfo) {
        IFileStore specsFilestore;
        String gcc = buildInfo.getProviderRunCommand(providerId);
        String compilerPath = "";
        try {
            compilerPath = project.getPersistentProperty(new QualifiedName("", "XL_compilerRoot"));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (compilerPath == null) {
            IPreferenceStore prefStore = XLCUIPlugin.getDefault().getPreferenceStore();
            compilerPath = prefStore.getString("XL_compilerRoot");
        }
        if (compilerPath == null) {
            compilerPath = "";
        }
        gcc = gcc.replaceAll("\\$\\{XL_COMPILER_ROOT\\}", compilerPath);
        String args = buildInfo.getProviderRunArguments(providerId);
        String specsFileName = RemoteXLCSpecsRunSIProvider.getSpecsFileName((IProject)project);
        if (gcc == null || args == null || specsFileName == null) {
            return null;
        }
        try {
            specsFilestore = RemoteXLCSpecsRunSIProvider.createSpecsFile((IProject)project, (String)specsFileName, null);
        }
        catch (CoreException e) {
            RDTLog.logError((Throwable)e);
            return null;
        }
        catch (IOException e) {
            RDTLog.logError((Throwable)e);
            return null;
        }
        String specsFilePath = FileSystemUtilityManager.getDefault().getPathFromURI(specsFilestore.toURI());
        args = args.replace("${specs_file_path}", specsFilePath);
        ArrayList<String> command = new ArrayList<String>();
        command.add(gcc);
        String[] stringArray = args.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            command.add(arg);
            ++n2;
        }
        return command;
    }
}

